<?php
$category = null;
$colTitle = '';
if(get_post_type() == 'product' || get_post_type() == 'product_variation'){
    $category = get_the_terms(get_the_ID(), 'product_cat');
    $colTitle = isset($category[0]) ? $category[0]->name.' - ' : '';
}    
?>

<article class="post-list-item">
<div class="col-md-4">
    <?php 
    if(has_post_thumbnail()){        
        the_post_thumbnail('sekers-post-list-image');
    }elseif(get_post_type() == 'product' && $category){
        $thumb_id = get_woocommerce_term_meta( $category[0]->term_id, 'thumbnail_id', true );
        echo wp_get_attachment_image($thumb_id, 'sekers-post-list-image', false, ['class' => 'wp-post-image']);
    }        
    else{
        echo '<img class="wp-post-image" src="'.get_template_directory_uri().'/dist/images/sekers-placeholder.png"/>';
    } ?>
</div>

<div class="col-md-8">

<?php 
$permalink = get_the_permalink();

if(get_post_type() == 'product_variation'){

    $vid = get_the_id();
    $pid = wp_get_post_parent_id($vid);
    $terms = wp_get_post_terms( $pid, 'product_cat' );
    $permalink = get_term_link($terms[0])."?pid={$pid}&vid={$vid}";

}
?>

    <h2 class="post-list-item__title"><a href="<?= $permalink ?>"><?php echo $colTitle.get_the_title();?></a></h2>
    <?php if(get_post_type() == 'post'){ ?>
    <span class="time-holder"><?= get_the_date(); ?></span>
    <?php } ?>
    <div class="entry-summary">
        <?php             
        if($category && isset($category[0])) {
            echo $category[0]->description;
        }
        else{                
            the_excerpt();
        }
        ?>
    </div>
</div>
</article>

