<?php
namespace B2\Scruffy;

class ThemeSetup
{

    public function __construct()
    {
        add_action('after_switch_theme', array($this, 'addStyleGuidePage'));
        add_action('after_switch_theme', array($this, 'addPrivacyPolicyPage'));
    }

    public function addStyleGuidePage()
    {
        $check = get_page_by_path( 'style-guide' );
        if (null == $check) {
            // page doesn't already exist
            $newPage = array(
                'post_type' => 'page',
                'post_title' => 'Style Guide',
                'post_name' => 'style-guide',
                'post_status' => 'publish'
            );
            wp_insert_post($newPage);
        }
    }

    public function addPrivacyPolicyPage()
    {
        $check = get_page_by_path( 'privacy-policy' );
        if (null == $check) {
            
            ob_start();
            locate_template( 'templates/placeholder-privacy-policy.php', true );
            $content = ob_get_clean();

            // page doesn't already exist
            $newPage = array(
                'post_type' => 'page',
                'post_title' => 'Privacy Policy',
                'post_name' => 'privacy-policy',
                'post_status' => 'publish',
                'post_content' => $content
            );
            wp_insert_post($newPage);
        }
    }
}