<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if (empty($product) || ! $product->is_visible()) {
    return;
}

?>

<div <?php post_class('col-md-6 col-lg-4 col-xl-3'); ?>>
	<a data-toggle="modal" data-target="#product<?= get_the_ID() ?>Modal" class="swatch">
	<?php
    /**
     * woocommerce_before_shop_loop_item_title hook.
     *
     * @hooked woocommerce_show_product_loop_sale_flash - 10
     * @hooked woocommerce_template_loop_product_thumbnail - 10
     */
    do_action('woocommerce_before_shop_loop_item_title');

    $title = get_the_title();
    $title = preg_replace('/&#8211;/', '<br/>', $title, 1);
    $title = preg_replace('/&#8212;/', '<br/>', $title, 1);
    $title = preg_replace('/&#8211;/', '', $title, 1);
    $title = preg_replace('/&#8212;/', '', $title, 1);

    echo '<h2 class="woocommerce-loop-product__title">' . $title . '</h2>';
    if ($product->is_downloadable()) {
        ?>
	<a href="<?= admin_url('admin-ajax.php') ?>?action=download_swatch&product_id=<?= get_the_ID() ?>"  class="btn btn-grey-blue btn-download-swatch" >Download Sample</a>
	<?php
    } ?>
	</a>

	<?php woocommerce_template_loop_add_to_cart();?>

	<?php
    $parentId = wp_get_post_parent_id(get_the_ID());
    $parent = get_post($parentId);
    /*
    product_type
    performance*/
    ?>

	<!-- Modal -->
	<div class="modal fade product-info-modal" id="product<?= get_the_ID() ?>Modal" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLongTitle"><?php echo get_the_title() ?></h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true"><i class="fas fa-times"></i></span>
					</button>
				</div>

				<div class="modal-body product-info-panel">
					<div class="row">
						<div class="col-12 product-info-modal__thumbnail">
							<?php echo woocommerce_get_product_thumbnail(); // WPCS: XSS ok.?>
						</div>
						<div class="col-12">
							<?php echo apply_filters('the_content', $parent->post_content); ?>
						</div>
						<div class="col-12">							
							<?php
                                
                                $type =  get_field('product_type', $parentId);

                                if ($type == 'wallcoverings') {
                                    get_template_part('templates/parts/product-info', 'wallpaper');
                                } else {
                                    get_template_part('templates/parts/product-info', 'fabric');
                                }
                            ?>							
						</div>
					</div>
				</div>

				<div class="modal-footer">
					<button type="button" class="btn btn-primary btn-download-swatch" data-dismiss="modal">Close</button>
					<?php
                    if ($product->is_downloadable()) {
                        ?>
						<a href="<?= admin_url('admin-ajax.php') ?>?action=download_swatch&product_id=<?= get_the_ID() ?>"  class="btn btn-grey-blue btn-download-swatch" >Download Sample</a>
						<?php
                    } ?>
					<?php woocommerce_template_loop_add_to_cart() ?>
				</div>
			</div>
		</div>
	</div>
</div>