<?php

$whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo();
$artistNames = [];
if($whatsOnInfo['associated_artists']) {
    foreach ($whatsOnInfo['associated_artists'] as $artist) {
        array_push($artistNames, $artist->post_title);
    }
}

$args = [
    'post_type' => 'whats-on',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'post_parent' => get_the_id(),
    'orderby' => 'menu_order',
    'order' => 'ASC',
];
$childPages = get_posts($args);

$firstTabTitle = count($artistNames) == 1 ? 'About ' . $artistNames[0] : 'About Exhibition';

$introduction = get_field('exhibition_introduction');
$description = get_field('exhibition_description');
$snippet = get_field('exhibition_snippet');

?>

<section class="p-header whats-on-single-header">
    <div class="p-header__title p-header-title">
        <div class="p-heaer-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            } ?>
            <div class="holder">
                <?php if($whatsOnInfo['associated_artists']) { ?><div class="artists ff-title"><?= implode(', ', $artistNames); ?></div><?php } ?>
                <h1 class="ff-main"><?php the_title(); ?></h1>
                <div class="date ff-main"><?= $whatsOnInfo['start_date'] . ' - ' . $whatsOnInfo['end_date']; ?></div>
            </div>
        </div>
    </div>
    <div class="p-header__filter p-header-filter">
        <div class="p-header-filter_contain contain">
            <div class="filter-wrapper">
                <ul class="ff-title" id="accordion-list">
                    <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                    <li class="currently-showing active order-1"><a href="/whats-on/"><?= $firstTabTitle; ?></a></li>
                    <?php foreach($childPages as $page) { ?>
                        <li class="order-2"><a href="<?= get_permalink($page->ID) ?>"><?= $page->post_title; ?></a></li>
                    <?php } ?>
                    <li class="order-2"><a href="/artworks/?type=sold">Sold Artworks</a></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<section class="whats-on-info">
    <div class="whats-on-info__exhibition whats-on-info-exhibition">
        <div class="whats-on-info-exhibition__contain contain">
            <div class="row">
                <?php if($introduction){ ?>
                    <div class="col-lg-6">
                        <div class="whats-on-info-exhibition__introduction"><?= $introduction; ?></div>
                    </div>
                <?php } ?>
                <div class="col-lg-6">
                    <?php if($description) { ?><div class="whats-on-info-exhibition__description"><?= $description; ?></div><?php } ?>
                    <?php if($snippet) { ?><div class="whats-on-info-exhibition__snippet"><?= $snippet; ?></div><?php } ?>
                </div>

                <?php if(get_post_thumbnail_id()) {
                    $imgID = get_post_thumbnail_id();
                    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                    $imageDetails = wp_get_attachment_image_src($imgID, 'whats-on-single-full'); ?>
                    <div class="col-12">
                        <div class="whats-on-info-exhibition__image-holder image-holder">
                            <img src="<?= $imageDetails[0]; ?>" alt="<?= $imageAlt; ?>" loading="lazy">
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<?php if($whatsOnInfo['associated_artists']) {
    $artists = $whatsOnInfo['associated_artists'] ?>
    <section class="about-the-artist">
        <div class="about-the-artist__contain contain">
            <?php foreach($artists as $artist) {

                $imgID = get_post_thumbnail_id($artist->ID);
                $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                $imageDetails = wp_get_attachment_image_src($imgID, 'artist-image');

                $introduction = get_field('artist_introduction', $artist->ID);
                $description = get_field('artist_description', $artist->ID);

                ?>
                <div class="about-the-artist__wrapper artist-wrapper">
                    <div class="artist-wrapper__title">
                        <h2 class="ff-title"><?= $artist->post_title; ?></h2>
                        <h3>Meet the artist</h3>
                    </div>
                    <div class="artist-wrapper__grid artist-grid">
                        <div class="artist-grid__image"><img src="<?= $imageDetails[0]; ?>" alt="<?= $imageAlt; ?>" loading="lazy"></div>
                        <div class="artist-grid__description">
                            <?php if($introduction) { ?><div class="introduction"><?= $introduction ?></div><?php } ?>
                            <?php if($description) { ?><div class="full"><?= $description ?></div><?php } ?>
                        </div>
                        <div class="artist-grid__films"></div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </section>
<?php } ?>
