<?php

namespace Blue2\Scruffy\Controllers;

class WhatsOnController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
    }

    private function registerFilters()
    {
    }

    public static function getWhatsOnArchiveInfo($id = null) {

        $whatsOnId = $id ?: get_the_id();

        $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

        $startDate = get_field('start_date', $whatsOnId);
        $endDate = get_field('end_date', $whatsOnId);
        $archiveDescription = get_field('archive_description', $whatsOnId);
        $associatedArtists = get_field('associated_artists', $whatsOnId);
        $archiveImage = get_field('archive_image', $whatsOnId);

        $imageSize = isset($_GET['type']) && $_GET['type'] == 'past' ? 'whats-on-archive-small' : 'whats-on-archive-large';

        if($archiveImage){
            $imgID = $archiveImage;
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
            $imageClass = 'archive-image';
        } elseif(!$archiveImage && get_the_post_thumbnail_url()){
            $imgID = get_post_thumbnail_id();
            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($imgID, $imageSize);
            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
            $imageClass = 'featured-image';
        } else{
            $image = $defaultImage;
            $imageClass = 'default-image';
        }

        $startDateOutput = date("d F Y", strtotime($startDate));
        $endDateOutput = date("d F Y", strtotime($endDate));


        $info = [
            'start_date' => $startDateOutput,
            'end_date' => $endDateOutput,
            'archive_description' => $archiveDescription,
            'associated_artists' => $associatedArtists,
            'archive_image' => $image,
            'archive_image_class' => $imageClass,
        ];
        return $info;
    }


}
