<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\WhatsOnController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'hamburger_menu' => 'Hamburger Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        new WhatsOnController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Artist::registerPostType();
        Post\WhatsOn::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('whats-on-archive-large', 776, 582, true);
        add_image_size('whats-on-archive-small', 364, 364, false);
    }

    public static function getDefaultImage() {
        $path = get_template_directory() . '/dist/images/TSG-main-logo.svg';
        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="l-header__logo" role="img" aria-label="The Scottish Gallery"',
            $file
        );
    }

}
