<?php

$whatsOnArgs = [
    'post_type' => 'whats-on',
    'posts_per_page' => -1,
    'post_status' => 'publish',
    'post_parent' => 0,
];

$whatsOnQuery = new WP_Query($whatsOnArgs);

if ( $whatsOnQuery->have_posts() ) {
    while ( $whatsOnQuery->have_posts() ) {
        $whatsOnQuery->the_post();
        $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo();
        $artistNames = [];
        foreach($whatsOnInfo['associated_artists'] as $artist){
            array_push($artistNames, $artist->post_title);
        }
        ?>
        <div class="col-12 whats-on-item standard">
            <div class="row">
                <div class="col-lg-6">
                    <div class="image-wrap">

                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="content-wrap">
                        <?php if($whatsOnInfo['associated_artists']) { ?><div class="artists ff-title"><?= implode(',', $artistNames) ?></div><?php } ?>
                        <h2><?php the_title(); ?></h2>
                        <div class="date"><?= $whatsOnInfo['start_date'] . ' - ' . $whatsOnInfo['end_date']; ?></div>
                        <div class="archive-description"><?= $whatsOnInfo['archive_description']; ?></div>
                        <a href="<?php the_permalink(); ?>" class="cta ff-title">Explore More</a>
                    </div>
                </div>
            </div>
        </div>
    <?php }
    wp_reset_postdata();
} else {
    get_template_part('templates/whats-on/layout/no-results');
} ?>
