<header class="l-header">
    <div class="l-header__contain contain">
        <a class="l-header__brand" href="<?= esc_url(home_url('/')); ?>">
            <?php
            $path = get_template_directory() . '/dist/images/TSG-main-logo.svg';
            $file = file_get_contents($path);
            // remove xml header
            $file = str_replace(
                '<?xml version="1.0" encoding="UTF-8"?>',
                '',
                $file
            );
            // add class and attributes for accessibility
            echo str_replace(
                '<svg',
                '<svg class="l-header__logo" role="img" aria-label="The Scottish Gallery"',
                $file
            );
            ?>
        </a>
        <nav class="l-header__nav l-nav">
            <div class="l-nav__holder ff-main">
                <?php
                if (has_nav_menu( 'main_menu' )) {
                    wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'l-nav__menu']);
                }
                ?>
                <div class="l-nav__icons l-icons">
                    <span class="l-icons__search far fa-search"></span>
                    <span class="l-icons__basket far fa-shopping-bag"></span>
                    <span class="l-icons__hamburger far fa-bars"></span>
                </div>
            </div>
        </nav>
    </div>
</header>
