<?php

$queryObject = get_queried_object();

$craftProductCategory = get_term_by( 'slug', 'craft-design', 'product_cat' );
$args = [
    'taxonomy' => 'product_cat',
    'hide_empty' => false,
    'parent'   => $craftProductCategory->term_id,
    'orderby' => 'menu_order',
    'order' => 'ASC'
];
$craftDesignSubCategories = get_terms( $args );
$activeTaxonomy = (is_tax() && $queryObject->slug) ? $queryObject->slug : "" ;
$filterCount = 0;

?>

<div class="p-header__filter p-header-filter p-collapsable-header-filter craft-filter">
    <div class="p-header-filter_contain contain">
        <div class="filter-wrapper">
            <ul class="ff-title" id="accordion-list">
                <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                <li class="craft-artists <?= $queryObject->slug == 'craft-design' && is_tax('artist-type') ? 'active order-1' : 'order-2';  ?>"><a href="/artist-type/craft-design/">Artists</a></li>
                <li class="all-categories <?= is_product_category() && ($queryObject->slug == 'craft-design') ? 'active order-1' : 'order-3';  ?>"><a href="/product-category/craft-design/">All</a></li>
                <?php if($craftDesignSubCategories) {
                    foreach ($craftDesignSubCategories as $subCategory) {
                        $filterCount++;
                        ?>
                        <li class="<?= 'filter-count-'.$filterCount; ?> <?= $subCategory->slug; ?> <?= $activeTaxonomy == $subCategory->slug ? 'active order-1' : 'order-3'; ?>">
                            <a href="<?= get_category_link($subCategory->term_id); ?>"><?= $subCategory->name; ?></a>
                        </li>
                    <?php }
                } ?>
            </ul>
        </div>
    </div>
</div>
