<?php get_header();
$queryObject = get_queried_object();
$craftProductCategory = get_term_by('slug', 'artworks', 'product_cat');
?>

<div class="product_cat-artworks-template custom-tax-archive">
    <section class="p-header p-artist-header product_cat-artworks-template__product-artworks-header">
        <div class="p-header__title p-header-title">
            <div class="p-header-title__contain contain">
                <?php if ( function_exists('yoast_breadcrumb') ) {
                    yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
                } ?>
                <h1 class="ff-title">Artworks</h1>
            </div>
        </div>
        <?php get_template_part('templates/shop/navigations/artworks-navigation'); ?>
    </section>
    <section class="product_cat-artworks-template__product-artworks-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php if ( have_posts() ) {
                    get_template_part('templates/shop/product-filter'); ?>
                    <div class="col-12">
                        <div class="artworks-holder">
                            <div class="row row-eq-height">
                                <?php while ( have_posts() ) {
                                    the_post();
                                    get_template_part('templates/shop/artworks-archive-item');
                                } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </div>
                <?php } else {
                    $noResultsTitle = get_field('no_results_title_artworks', 'option');
                    $noResultsDescription = get_field('no_results_description_artworks', 'option');
                    ?>
                    <div class="col-12">
                        <div class="no-results">
                            <?php if($noResultsTitle) { ?><h3 class="title"><?= $noResultsTitle; ?></h3><?php } ?>
                            <?php if($noResultsDescription) { ?><div class="description"><?= $noResultsDescription; ?></div><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="custom-pagination">
                <?php the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('<', 'textdomain'),
                    'next_text' => __('>', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </section>
</div>

<?php get_footer(); ?>
