<?php
$events = get_field('events');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
?>

<main class="single-events-layout">
    <div class="contain single-events-layout__contain">
        <?php if($events) { ?>
            <div class="single-events-layout__output event-output">
                <div class="row">
                    <?php foreach($events as $event) {
                        $title = $event->post_title;
                        $date = get_field('date_time', $event->ID);
                        $subtitle = get_field('subtitle', $event->ID);
                        $dateOutput = date("l jS F, h:ia", strtotime($date));

                        if(get_post_thumbnail_id($event->ID)){
                            $imgID = get_post_thumbnail_id($event->ID);
                            $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                            $imageDetails = wp_get_attachment_image_src($imgID, 'whats-on-archive-large');
                            $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }
                        ?>
                        <div class="col-lg-6 event-output__item forthcoming">
                            <div class="image-wrap <?= $imageClass; ?>">
                                <a href="<?= get_the_permalink($event->ID); ?>">
                                    <?= $image;  ?>
                                </a>
                            </div>
                            <div class="content-wrap">
                                <div class="date"><?= $dateOutput; ?></div>
                                <h2><?= $event->post_title; ?></h2>
                                <?php if($subtitle) { ?><div class="subtitle"><?= $subtitle; ?></div><?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    </div>
    <?php get_template_part('templates/single-layouts/associated-artists'); ?>
</main>

