<?php
$dateOutput = date("d F Y", strtotime(get_the_date()));

$imgID = get_post_thumbnail_id();
if($imgID) {
    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($imgID, 'post-single');
    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
}
?>

<section class="p-header event-single-header event-single-header">
    <div class="p-header__title p-header-title">
        <div class="p-header-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            } ?>

            <div class="holder">
                <h1 class="ff-title"><?php the_title(); ?></h1>
                <div class="date ff-main"><?= $dateOutput; ?></div>
            </div>
        </div>
    </div>
</section>

<main class="standard-output">
    <?php if(get_field('flexible_sections')) { ?>
        <div class="flexible-layout">
            <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections'); ?>
        </div>
    <?php } else { ?>
        <div class="normal-layout custom-content">
            <div class="contain">

                <?php if($imgID) {
                    $caption = wp_get_attachment_caption($imgID); ?>
                    <div class="image-wrapper">
                        <?= $image; ?>
                        <?php if($caption) { ?><div class="caption"><?= $caption; ?></div><?php } ?>
                    </div>
                <?php } ?>

                <div class="main-content-wrapper">
                    <?php the_content(); ?>
                </div>
            </div>
        </div>
    <?php } ?>
</main>


