<?php

namespace Blue2\Scruffy\Controllers;

use Mpdf\Tag\P;
use Imagick;

class FMProController
{
    CONST TABLE = 'Scottish Gallery';
    CONST ARTWORK = 'Artwork List';
    CONST USER = 'Blue2';
    CONST PASS = 'Sc0tt1shG';
    CONST ENDPOINT = 'https://office.scottish-gallery.co.uk:8443/fmi/data/';
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();

        $this->dataApi = new \Lesterius\FileMakerApi\DataApi(self::ENDPOINT, self::TABLE, null, self::USER, self::PASS);
    }

    private function registerActions()
    {
        add_action('wp_dashboard_setup', [$this, 'addApiTestWidget']);
        add_action('rest_api_init', function () {
            register_rest_route('scotgal/v1', '/test-endpoints/', [
                'methods' => 'GET',
                'callback' => [$this, 'getRecords'],
            ]);
        });
        add_action('rest_api_init', function () {
            register_rest_route('scotgal/v1', '/test-sale/', [
                'methods' => 'GET',
                'callback' => [$this, 'updateRecords'],
            ]);
        });
        add_action( 'woocommerce_checkout_order_processed', [$this, 'updateFMPorderComplete'], 50, 1 );
    }

    private function registerFilters()
    {
        add_filter('upload_mimes', [$this, 'addingBMPSupport'], 1, 1);
    }

    
    public function updateFMPorderComplete($orderID){
        if(get_field('enable_order_sync', 'options')){
            $order = wc_get_order( $orderID );
            $items = $order->get_items();
            $records = [];
            foreach($items as $item){
                $product = wc_get_product($item->get_product_id());
                $records['record_id'] = get_field('record_id', $item->get_product_id()); // should be record id, change me if we change sku
            }
            $this->updateRecords($records);
        }
    }

    

    public function addingBMPSupport($mime_types){
        $mime_types['bmp'] = 'image/x-ms-bmp'; //Adding bmp extension
        return $mime_types;
    }

    public function addApiTestWidget()
    {
        global $wp_meta_boxes;
        if (current_user_can('administrator')) {
            wp_add_dashboard_widget('addTestWidget', 'Testing APi', [$this, 'testApi']);
        }
    }

    public function testApi() { ?>
        <form action="/wp-json/scotgal/v1/test-endpoints" method="GET" name="xeroOAuth">
            <p>Test Api for File Maker Pro</p>
            <input class="button button-primary " type="submit" name="testApi">
        </form>
      <?php
    }
    private function createArtist($name){
        $postID = wp_insert_post( array( 'post_title' => $name,
            		'post_type' => 'artist',
            		'post_status' => 'publish'
            	)
            );
        return $postID;
    }
    private function searchForArtist($name){
        global $wpdb;

        $artistId = $wpdb->get_var($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE post_title LIKE '%s' LIMIT 1", $name));

        if($artistId) return $artistId;

        return false;
    }

    private function searchBySku($sku){
        global $wpdb;

        $productId = $wpdb->get_var($wpdb->prepare("SELECT post_id FROM $wpdb->postmeta WHERE meta_key='_sku' AND meta_value='%s' LIMIT 1", $sku));

        if($productId) return $productId;

        return false;
    }

    private function assignMedium($name, $postID){
        if($name == 'monograph' || $name == 'monoprint' || $name == 'monotype'){
            $name = 'Monograph/Monoprint/Monotype';
        }
        $termID = term_exists($name, 'medium');

        if($termID){
            wp_set_post_terms($postID, [$termID['term_id']], 'medium');
        }
    }

    private function assignArtist($artist, $postID){
        if(!$artistID = $this->searchForArtist($artist)){
            $artistID = $this->createArtist($artist);
        }
        $relatedArtists = get_field('associated_artists', $postID, false);
        $relatedArtists[] = $artistID;
        update_field('associated_artists', $relatedArtists, $postID);
    }

    private function get_content($url){
        $stream = stream_context_create([
            'ssl'=> [
                'verify_peer'=> false,     
                'verify_peer_name'=> false, 
            ],
            'http' => [
              'timeout' => 30     
            ]
        ]);
        $img = file_get_contents($url,0,$stream);
        return $img;
    }

    private function convertImage($imgData, $filepath, $path, $name){
        $img = new Imagick();
        $img->readImage($filepath);
        $sizes = getimagesize($filepath);
        $img->setImageFormat('jpeg');
        $img->writeImage($path . '/' . $name . '.jpg');
        $img->clear();
        return $path . '/' . $name . '.jpg';
    }

    private function setProductImage($image, $postID){
        $pathInfo = pathinfo($image);
        $imageName = $pathInfo['filename'];
        $uploadDir = wp_upload_dir(); // Set upload folder
        $imageData = $this->get_content($image); // Get image data
        $uFileName = wp_unique_filename( $uploadDir['path'], $imageName ); // Generate unique name
        
        $filename = basename( $uFileName ); // Create image file name


        // Check folder permission and define file location
        if( wp_mkdir_p( $uploadDir['path'] ) ) {
            $file = $uploadDir['path'] . '/' . $filename . '.bmp';
            $path = $uploadDir['path'];
        } else {
            $file = $uploadDir['basedir'] . '/' . $filename . '.bmp';
            $path = $uploadDir['basedir'];
        }
        
        // Create the image  file on the server
        file_put_contents( $file, $imageData );

        $im = $this->convertImage($imageData, $file, $path, $uFileName);

        unlink($file);

        $newUFileName = wp_unique_filename( $uploadDir['path'], $im ); // Generate unique name
        
        $newFilename = basename( $newUFileName ); // Create image file name

        // Check image file type
        $wp_filetype = wp_check_filetype( $newFilename, null );

        // Set attachment data
        $attachment = array(
            'post_mime_type' => $wp_filetype['type'],
            'post_title'     => sanitize_file_name( $newFilename ),
            'post_content'   => '',
            'post_status'    => 'inherit'
        );

        // Create the attachment
        $attachID = wp_insert_attachment( $attachment, $im, $postID );

        // Include image.php
        require_once(ABSPATH . 'wp-admin/includes/image.php');

        // Define attachment metadata
        $attachData = wp_generate_attachment_metadata( $attachID, $im );

        // Assign metadata to attachment
        wp_update_attachment_metadata( $attachID, $attachData );

        // And finally assign featured image to post
        set_post_thumbnail( $postID, $attachID );
    }

    private function saveRecord($record){

        // cGalleryRef
        // Artist
        // Title
        // Medium:"monotype"
        // Artwork_ArtCalculations::VendorsName
        // cCurrentStatus:"Sold" / "Unsold"
        // Home::gText1 ?
        // Artwork_ArtCalculations::GrossWallPrice
        // cSizeList:"30.5 x 42.5 cm"
        // cCurrentLocation:"10 A"
        // Home::gFilter:"Unsold"
        // OnWebsite:1
        // Artwork_ArtworkImages::container
        // StockNumber:36933 // sku?
        // Year:"2018"
        // Artwork_ArtCalculations_Invoices::InvoiceDate

        // using recordID as SKU?
        $title = $record['fieldData']['Title'];
        $artist = $record['fieldData']['Artist'];
        $imageUrl = $record['fieldData']['Artwork_ArtworkImages::container'];
        $price = $record['fieldData']['Artwork_ArtCalculations::GrossWallPrice'];
        $status = $record['fieldData']['cCurrentStatus'];
        $medium = $record['fieldData']['Medium'];
        $sku = $record['fieldData']['StockNumber'];
        $size = $record['fieldData']['cSizeList'];
        $recordId = $record['recordId'];
        $modId = $record['modId'];
        if (!$postID = $this->searchBySku($sku)){  
            //product not found, creating new one
            $postID = wp_insert_post( array( 'post_title' => $title,
            		'post_type' => 'product',
            		'post_status' => 'draft'
            	)
            );
        }
        
        // update_post_meta( $postID, 'total_sales', '0' );
		// update_post_meta( $postID, '_downloadable', 'no' );
		// update_post_meta( $postID, '_virtual', 'yes' );
		// update_post_meta( $postID, '_regular_price', '' );
        // update_post_meta( $postID, '_sale_price', '' );
        // update_post_meta( $postID, '_purchase_note', '' );
		// update_post_meta( $postID, '_featured', 'no' );
		
        // update_post_meta( $postID, '_sale_price_dates_from', '' );
		// update_post_meta( $postID, '_sale_price_dates_to', '' );
        // update_post_meta( $postID, '_sold_individually', '' );
        
        $this->assignArtist($artist, $postID);
        $this->assignMedium($medium, $postID);

        wp_set_object_terms( $postID, 'simple', 'product_type' ); // set product is simple/variable/grouped

        update_post_meta( $postID, '_sku', $sku  );
        update_post_meta( $postID, '_backorders', 'no' );
        update_post_meta( $postID, '_price', $price );
        update_post_meta( $postID, '_regular_price', $price );
        update_post_meta( $postID, '_manage_stock', 'yes' ); // activate stock management
        update_post_meta( $postID, '_backorders', 'no' );

        update_field('mod_id', $modId, $postID);
        update_field('record_id', $recordId, $postID);
        
        $sizeSplit = explode('x', $size);
        $width = trim($sizeSplit[0]);
        $height = trim( str_replace('cm','', $sizeSplit[1]));
        if(count($sizeSplit) > 1){
            update_post_meta( $postID, '_width', $width );
            update_post_meta( $postID, '_height', $height );
        }

        if($status == 'Available'){
            update_post_meta( $postID, '_visibility', 'visible' );
            update_post_meta( $postID, '_stock_status', 'instock');
            wc_update_product_stock($postID, 1, 'set'); // set 1000 in stock
        }else{
            update_post_meta( $postID, '_stock_status', 'outofstock');
            wc_update_product_stock($postID, 0, 'set'); // set 1000 in stock
        }

		if($imageUrl !== '' || !has_post_thumbnail($postID)){
            $this->setProductImage($imageUrl, $postID);
        }
    }

    private function saveRecords(){
        foreach($this->records as $record){
            $this->saveRecord($record);
        }
    }

    public function updateRecords($records){
        foreach($records as $record){
            try{
                $data = [
                    'Status' => 'Sold'
                ];
                $recordId = $this->dataApi->editRecord(self::TABLE, $record['record_id'], $data);
            }catch(\Exception $e){
                var_dump($e);
                die;
            }
        }
    }

    public function getRecords(){
        if(get_field('enable_product_sync', 'options')){
            $offset = 0;
            $limit = 500;
            $collectedAll = false;
            $this->records = [];
            $query = [
                [
                    'fields' => [
                        ['fieldname' => 'OnWebsite', 'fieldvalue' => 1]
                    ]
                ]
            ];
            while(!$collectedAll){
                try{
                    $newRecords = $this->dataApi->findRecords(self::ARTWORK, $query, $offset, $limit);

                    if(count($newRecords) > 0){
                        
                            $this->records = array_merge($this->records, $newRecords);
                            $offset += $limit;
                            if(count($newRecords) < $limit){
                                $collectedAll = true;
                            }
                    }else{
                        $collectedAll = true;
                    }
                }catch (\Exception $e){
                    echo $e->getMessage();
                    $collectedAll = true;
                }
            }
            $this->saveRecords();
        }else{
            echo "Order Sync Disabled.";
        }
    }
}
