<?php

$slides = get_sub_field('slides');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();


if($slides) { ?>
    <section class="custom-flexible-section full-width-slider">
        <div class="full-width-slider__contain contain">

            <div class="prev-item swiper-nav-button"><div class="inner"><span class="far fa-arrow-left"></span></div></div>
            <div class="next-item swiper-nav-button"><div class="inner"><span class="far fa-arrow-right"></span></div></div>

            <div class="full-width-slide__output slider-output">
                <div class="swiper-container slider-output__container">
                    <div class="swiper-wrapper slider-output__wrapper">
                        <?php foreach($slides as $slide) { ?>
                            <div class="swiper-slide slider-output__slide <?= $slide['slide_type']; ?>">
                                <?php if($slide['slide_type'] == 'exhibition-selection') {
                                    $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo($slide['exhibition_selector'], 'whats-on-single-full');
                                    $artistNames = [];
                                    if($whatsOnInfo['associated_artists']) {
                                        foreach ($whatsOnInfo['associated_artists'] as $artist) {
                                            array_push($artistNames, '<a href="' . get_the_permalink($artist->ID) . '">' . $artist->post_title . '</a>');
                                        }
                                    }
                                    $mainTitle = implode(', ', $artistNames) ?: "";
                                    $subtitle = $whatsOnInfo['title'];
                                    $imageClass = $whatsOnInfo['archive_image_class'];
                                    $image = $whatsOnInfo['archive_image'];
                                    $startDate = $whatsOnInfo['start_date'];
                                    $endDate = $whatsOnInfo['end_date'];
                                    $description = $whatsOnInfo['archive_description'];
                                    $link = get_the_permalink($slide['exhibition_selector']);
                                    $mainTitleLink = true;

                                } else {
                                    $mainTitle = $slide['slide_main_title'];
                                    $subtitle = $slide['slide_subtitle'];
                                    $startDate = $slide['slide_start_date'] ? date("d F Y", strtotime($slide['slide_start_date'])) : "";
                                    $endDate = $slide['slide_end_date'] ? date("d F Y", strtotime($slide['slide_end_date'])) : "";
                                    $description = $slide['slide_description'];
                                    $slideImageID = $slide['slide_image'];


                                    $link = $slide['slide_url']['url'];
                                    $mainTitleLink = $slide['slide_url']['url'];

                                    if($slideImageID) {
                                        $imageDetails = wp_get_attachment_image_src($slideImageID, 'whats-on-single-full');
                                        $imageAlt = get_post_meta($slideImageID, '_wp_attachment_image_alt', TRUE);
                                        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                                        $imageClass = 'featured-image';
                                    } else {
                                        $image = $defaultImage;
                                        $imageClass = 'default-image';
                                    }

                                }
                                ?>
                                <div class="image-wrapper <?= $imageClass; ?>">
                                    <a href="<?= $link; ?>">
                                        <?= $image; ?>
                                    </a>
                                    <div class="swiper-pagination"></div>
                                </div>
                                <div class="content-wrapper">
                                    <div class="row">
                                        <div class="col-lg-5">
                                            <?php if($mainTitle) { ?>
                                                <?php if($mainTitleLink && $slide['slide_type'] !== 'exhibition-selection') { ?><a href="<?= $mainTitleLink ?>"><?php } ?>
                                                    <h2><?= $mainTitle; ?></h2>
                                                <?php if($mainTitleLink && $slide['slide_type'] !== 'exhibition-selection') { ?></a><?php } ?>
                                            <?php } ?>
                                        </div>
                                        <div class="col-lg-7">
                                            <div class="slide-content-holder">
                                                <div class="primary-content">
                                                    <?php if($subtitle) { ?>
                                                        <?php if($link) { ?><a href="<?= $link ?>"><?php } ?>
                                                            <h3 class="ff-title"><?= $subtitle; ?></h3>
                                                        <?php if($link) { ?></a><?php } ?>
                                                    <?php } ?>
                                                    <?php if($startDate || $endDate) { ?><div class="date"><span class="start-date"><?= $startDate; ?></span><?php if($endDate) { ?><span class="end-date"> - <?= $endDate ?></span><?php } ?></div><?php } ?>
                                                </div>
                                                <div class="secondary-content">
                                                    <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
