<?php
$craft = get_term_by('slug', 'craft-design', 'artist-type');
$artistTypes = get_terms(['taxonomy' => 'artist-type', 'exclude' => [$craft->term_id]]);
$activeTaxonomy = false;
$artistArgs = [];
$taxQuery = [];
$info = get_queried_object();

if(is_tax()) {
    $activeTaxonomy = $info->slug;
    $taxQuery[] = [
        'taxonomy' => 'artist-type',
        'field' => 'slug',
        'terms' => $activeTaxonomy
    ];
} else {
    //Excludes craft and design from standard artist archive
    $taxQuery[] = [
        'taxonomy' => 'artist-type',
        'field' => 'id',
        'terms' => [$craft->term_id],
        'operator' => 'NOT IN',
    ];
}

$title = is_tax() ? 'Artists - ' . $info->name : 'Artists';
?>
<section class="p-header p-artist-header">
    <div class="p-header__title p-header-title">
        <div class="p-header-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            }

            if(is_tax() && $info->slug == 'craft-design') { ?>
                <h1 class="craft-title">Craft <span>&</span> Design</h1>
            <?php } else { ?>
                <h1 class="ff-title"><?= $title; ?></h1>
            <?php } ?>
        </div>
    </div>

    <?php if(is_tax() && $info->slug == 'craft-design') {
        get_template_part('templates/sections/craft-design-navigation');
    } else { ?>
        <div class="p-header__filter p-header-filter">
            <div class="p-header-filter_contain contain">
                <div class="filter-wrapper">
                    <ul class="ff-title" id="accordion-list">
                        <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                        <li class="currently-showing <?= !is_tax() ? 'active order-1' : 'order-2';  ?>"><a href="/artists/">All</a></li>
                        <?php
                        if($artistTypes) {
                            foreach ($artistTypes as $type) { ?>
                                <li class="<?= $type->slug; ?> <?= $activeTaxonomy == $type->slug ? 'active order-1' : 'order-2'; ?>">
                                    <a href="/artist-type/<?= $type->slug; ?>"><?= $type->name; ?></a>
                                </li>
                            <?php }
                        } ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php } ?>
</section>
<main class="p-archive-artists-output">
    <div class="p-archive-artists-output__contain contain">

        <div class="p-archive-artists-output__mode-switch ff-title">
            <a href="" id="view-by-grid" role="button"><span class="fas fa-th-large"></span>View by grid</a>
            <a href="" id="view-by-list" class="inactive" role="button"><span class="fas fa-list"></span>View by list</a>
        </div>

        <?php
        $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
        $artistArgs = [
            'post_type' => 'artist',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'orderby' => 'title',
            'order' => 'ASC',
            'tax_query' => $taxQuery
        ];

        $artistQuery = new WP_Query($artistArgs);
        $artistData = [];

        if ( $artistQuery->have_posts() ) {
            while ($artistQuery->have_posts()) {
                $artistQuery->the_post();
                $firstLetter = get_the_title()[0];


                if(get_post_thumbnail_id(get_the_id())){
                    $imgID = get_post_thumbnail_id(get_the_id());
                    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                    $imageDetails = wp_get_attachment_image_src($imgID, 'artist-image-large');
                    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
                    $imageClass = 'featured-image';
                } else {
                    $image = $defaultImage;
                    $imageClass = 'default-image';
                }

                $hoverOverlay = get_field('artist_hover_image');

                if($hoverOverlay){
                    $imgID = $hoverOverlay['id'];
                    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                    $imageDetails = wp_get_attachment_image_src($imgID, 'artist-image');
                    $imageOverlay = $imageDetails[0];
                }

                $artistData[$firstLetter][] = [
                    'id' => get_the_id(),
                    'title' => get_the_title(),
                    'slug' => get_post_field('post_name', get_post()),
                    'image' => $image,
                    'image_class' => $imageClass,
                    'image_overlay' => $hoverOverlay ? $imageOverlay : '',
                    'image_overlay_alt' => $hoverOverlay ? $imageAlt : ''
                ];

            } wp_reset_postdata();
        }

        if($artistData) { ?>
        <div class="artist-output list-view">
            <?php foreach($artistData as $key => $data) { ?>
                <div class="artist-output__letter artist-letter">
                    <div class="letter ff-title"><?= $key; ?></div>
                    <ul>
                        <?php foreach($data as $artist) { ?>
                            <li class="artist-letter__item">
                                <a href="<?= get_the_permalink($artist['id']); ?>">
                                    <?= $artist['title']; ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
            <?php } ?>
        </div>

        <div class="artist-output grid-view">
            <?php foreach($artistData as $key => $data) { ?>
                <?php foreach($data as $artist) { ?>
                    <div class="artist-output__letter artist-letter">
                        <li class="artist-letter__item">
                            <a href="<?= get_the_permalink($artist['id']); ?>">
                                <div class="image-wrapper <?= $artist['image_class'] ?>">
                                    <?= $artist['image']; ?>
                                    <?php if($artist['image_overlay']) { ?><div class="hover-overlay"><img src="<?= $artist['image_overlay']; ?>" alt="<?= $artist['image_overlay_alt']; ?>" loading="lazy"/></div><?php } ?>
                                </div>
                                <?= $artist['title']; ?>
                            </a>
                        </li>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
    </div>

    <?php } ?>
    </div>
</main>
