<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
?>
<div class="custom-notices">
    <div class="contain">
        <?php
        /**
         * Hook: woocommerce_before_single_product.
         *
         * @hooked woocommerce_output_all_notices - 10
         */
        do_action( 'woocommerce_before_single_product' );

        if ( post_password_required() ) {
            echo get_the_password_form(); // WPCS: XSS ok.
            return;
        } ?>
    </div>
</div>

<?php
$associatedArtists = get_field('associated_artists');
$extraTitleInfo = get_field('extra_title_info');
$additionalInformation = get_field('additional_information');

$length = $product->get_length();
$width = $product->get_width();
$height = $product->get_height();
$diameter = get_post_meta( $product->get_id(), '_diameter', true );

$sizeString = "";

if($length) {
    $sizeString .= "L:" . $length . 'cm ';
}
if($height){
    $sizeString .= "H:" . $height . 'cm ';
}
if($width){
    $sizeString .= "W:" . $width . 'cm ';
}
if($diameter){
    $sizeString .= "D:" . $diameter . 'cm ';
}

$publications = has_term('publications', 'product_cat');
$publicationLink = get_field('publication_link');

$itemStatus = $product->is_in_stock($id) ? 'in-stock' : 'out-of-stock';
$itemStatusLabel = $product->is_in_stock($id) ? 'Artwork Available' : 'Artwork Unavailable';
$productReserved = get_field('product_reserved');

$productCheck = false;
$artworksProductCategory = get_term_by('slug', 'artworks', 'product_cat');
$craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
$productCategories = get_the_terms(get_the_id(), 'product_cat');
if($productCategories) {
    foreach ($productCategories as $category) {
        if ($category->parent == $artworksProductCategory->term_id || $category->parent == $craftProductCategory->term_id) {
            $productCheck = true;
            break;
        }
    }
}


?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <div class="contain">

        <div class="product-main">
            <div class="row">
                <div class="col-lg-6 image-col">
                    <?php
                    $imgID = get_post_thumbnail_id();
                    $galleryIDs = $product->get_gallery_image_ids();
                    if($imgID && !$galleryIDs) {
                        $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                        $imageDetails = wp_get_attachment_image_src($imgID, 'flexible-split-50');
                        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                        echo $image;
                    } else {

                        if($imgID) {
                            $featuredImageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                            $featuredImageFullDetails = wp_get_attachment_image_src($imgID, 'flexible-split-50');
                            $featuredImageThumbDetails = wp_get_attachment_image_src($imgID, 'thumbnail-gallery');
                            $featuredImageFull = '<img src="' . $featuredImageFullDetails[0] . '" alt="' . $featuredImageAlt . '" loading="lazy"/>';
                            $featuredImageThumb = '<img src="' . $featuredImageThumbDetails[0] . '" alt="' . $featuredImageAlt . '" loading="lazy"/>';
                        }
                        ?>

                        <div class="thumbnail-gallery">
                            <div thumbsSlider="" class="swiper-container mySwiper">
                                <div class="swiper-wrapper">

                                    <?php if ($imgID) { ?>
                                        <div class="swiper-slide">
                                            <div class="image-wrapper">
                                                <?= $featuredImageThumb; ?>
                                            </div>
                                        </div>
                                    <?php } ?>

                                    <?php foreach($galleryIDs as $id) {
                                        $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                                        $imageDetails = wp_get_attachment_image_src($id, 'thumbnail-gallery');
                                        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>'; ?>
                                        <div class="swiper-slide">
                                            <div class="image-wrapper">
                                                <?= $image; ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                <div class="custom-button-prev thumbnail-nav"><span class="far fa-chevron-left"></span></div>
                                <div class="custom-button-next thumbnail-nav"><span class="far fa-chevron-right"></span></div>
                            </div>
                            <div class="swiper-container mySwiper2">
                                <div class="swiper-wrapper">

                                    <?php if ($imgID) { ?>
                                        <div class="swiper-slide">
                                            <?= $featuredImageFull; ?>
                                        </div>
                                    <?php } ?>

                                    <?php foreach($galleryIDs as $id) {
                                        $imageDetails = wp_get_attachment_image_src($id, 'flexible-split-50');
                                        $image = '<img src="' . $imageDetails[0] . '" alt="" loading="lazy"/>'; ?>
                                        <div class="swiper-slide">
                                            <?= $image; ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>



                    <?php } ?>
                </div>
                <div class="col-lg-6 content-col">

                    <div class="product-information">
                        <div class="top-info">
                            <?php if($associatedArtists) { ?>
                                <ul class="associated-artists">
                                    <?php foreach($associatedArtists as $artist) { ?>
                                        <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                                    <?php } ?>
                                </ul>
                            <?php } ?>
                            <h1><?php the_title(); ?><?php if($extraTitleInfo) { echo ', ' . $extraTitleInfo; } ?></h1>
                            <?php if($additionalInformation) { ?><div class="additional-information"><?= $additionalInformation; ?></div><?php } ?>
                            <?php if($sizeString) { ?><div class="dimensions"><?= $sizeString; ?></div><?php } ?>
                        </div>
                        <div class="description"><?php the_content(); ?></div>

                        <?php if($product->get_price()) { ?>
                            <div class="pricing">
                                <?php if($itemStatus == 'in-stock') { ?>
                                    <div class="price"><?= get_woocommerce_currency_symbol() . $product->get_price(); ?></div>
                                <?php } else { ?>
                                    <div class="price">Sold</div>
                                <?php } ?>
                            </div>

                            <?php if($productReserved && $itemStatus == 'in-stock') { ?>
                                <div class="reserved">Reserved</div>
                            <?php } ?>
                        <?php } ?>

                        <?php

                        $viewOnWall = get_field('matterport_link');
                        if($viewOnWall) { ?>
                            <a href="<?= $viewOnWall; ?>" target="_blank" class="view-on-wall gold-button">View in Virtual Gallery</a>
                        <?php } ?>

                        <?php if($itemStatus == 'in-stock') { ?>
                            <div class="ctas">
                                <?php if(!$productReserved) { ?>
                                    <a href="?add-to-cart=<?= get_the_id(); ?>" class="button buy-now">Buy Now</a>
                                <?php } ?>
                                <?php if($publications && $publicationLink) { ?>
                                    <a href="<?= $publicationLink; ?>" target="_blank" class="button enquire">View</a>
                                <?php } else { ?>
                                    <a href="/enquire/" class="button enquire">Enquire</a>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </div>


                </div>
            </div>
        </div>

        <div class="custom-related-products">
            <?php
            /**
             * Hook: woocommerce_after_single_product_summary.
             *
             * @hooked woocommerce_output_product_data_tabs - 10
             * @hooked woocommerce_upsell_display - 15
             * @hooked woocommerce_output_related_products - 20
             */
            do_action( 'woocommerce_after_single_product_summary' );
            ?>
        </div>

        <?php
        $artists = get_field('associated_artists');
        if($artists) { ?>
            <div class="about-the-artist">

                <?php foreach($artists as $artist) {

                    $imgID = get_post_thumbnail_id($artist);
                    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                    $imageDetails = wp_get_attachment_image_src($imgID, 'artist-image');

                    $introduction = get_field('artist_introduction', $artist);
                    $description = get_field('artist_description', $artist);
                    $film = get_field('featured_artist_film', $artist);

                    ?>
                    <div class="about-the-artist__wrapper artist-wrapper">
                        <div class="artist-wrapper__title">
                            <h2 class="ff-title"><?= get_the_title($artist); ?></h2>
                            <h3>Meet the artist</h3>
                        </div>
                        <div class="artist-wrapper__grid artist-grid">
                            <?php if($imgID) { ?><div class="artist-grid__image"><img src="<?= $imageDetails[0]; ?>" alt="<?= $imageAlt; ?>" loading="lazy"/></div><?php } ?>
                            <div class="artist-grid__description <?= $imgID ? 'image-present' : 'no-image-present'; ?>">
                                <?php if($introduction) { ?><div class="introduction"><?= $introduction ?></div><?php } ?>
                                <?php if($description) { ?><div class="full"><?= $description ?></div><?php } ?>
                            </div>
                            <div class="artist-grid__films">
                                <?php if($film) { ?>
                                    <div class="frame-holder">
                                        <?php \Blue2\Scruffy\Controllers\WhatsOnController::getFeaturedArtistFilm('featured_artist_film', $artist); ?>
                                    </div>
                                <?php } ?>
                                <?php
                                $otherFilms = get_field('films', $artist);
                                $activeFilms = get_field('activate_films', $artist);
                                if($activeFilms && $otherFilms) { ?>
                                    <a href="<?= get_the_permalink($artist->ID) . 'films/' ?>" class="gold-button">View all films</a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
