<?php

$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$id = $args[0];

if(get_post_thumbnail_id($id)){
    $imgID = get_post_thumbnail_id($id);
    $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($imgID, 'flexible-standard-media');
    $image = '<img src=" ' . $imageDetails[0] . '" alt="'. $imageAlt .'" loading="lazy">';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}

$hoverOverlay = get_field('artist_hover_image');

if($hoverOverlay){
    $hoverImgID = $hoverOverlay['id'];
    $hoverImageAlt = get_post_meta($hoverImgID, '_wp_attachment_image_alt', TRUE);
    $hoverImageDetails = wp_get_attachment_image_src($hoverImgID, 'flexible-standard-media');
    $imageOverlay = $hoverImageDetails[0];
}


?>


<a href="<?= get_the_permalink($id); ?>">
    <div class="image-wrapper <?= $imageClass; ?>">
        <?= $image; ?>
        <?php if($hoverOverlay) { ?><div class="hover-overlay"><img src="<?= $imageOverlay; ?>" alt="<?= $hoverImageAlt; ?>" loading="lazy"/></div><?php } ?>
    </div>
    <h3><?= get_the_title(); ?></h3>
</a>
