<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$postThumbnailID = get_post_thumbnail_id();

if($postThumbnailID) {
    $imageAlt = get_post_meta($postThumbnailID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($postThumbnailID, 'artist-image-large');
    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}
?>

<div class="col-sm-6 col-lg-4 col-xl-3 general-item">
    <a href="<?= get_the_permalink(); ?>">
        <div class="image-wrapper <?= $imageClass; ?>">
            <?= $image; ?>
        </div>
        <div class="content-wrap">
            <div class="date"><?= date("l jS F, h:ia",  strtotime(get_field('date_time'))); ?></div>
            <h2><?= get_the_title(); ?></h2>
        </div>
    </a>
</div>
