<?php get_header();
$queryObject = get_queried_object();
$craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
?>

<div class="product_cat-craft-template custom-tax-archive">
    <section class="p-header p-artist-header product_cat-craft-template__product-craft-header">
        <div class="p-header__title p-header-title">
            <div class="p-header-title__contain contain">
                <?php if ( function_exists('yoast_breadcrumb') ) {
                    yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
                } ?>
                <?php if($queryObject->parent == $craftProductCategory->term_id) { ?>
                    <h2 class="craft-title">Craft <span>&</span> Design</h2>
                    <h1 class="craft-taxonomy-title"><?php single_term_title(); ?></h1>
                <?php } else { ?>
                    <h1 class="craft-title">Craft <span>&</span> Design</h1>
                <?php } ?>
            </div>
        </div>
        <?php get_template_part('templates/shop/navigations/craft-design-navigation'); ?>
    </section>
    <section class="product_cat-craft-template__product-craft-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php
                if(term_exists('museum-collections') && $queryObject->slug == 'museum-collections') {

                    $museumList = get_field('museum_list', 'option');

                    ?>
                    <div class="col-12 museum-collections-info">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="primary-text">
                                    <?php the_field('primary_museum_text', 'option') ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="secondary-text">
                                    <?php the_field('secondary_museum_text', 'option') ?>
                                </div>

                                <?php if($museumList) { ?>
                                    <div class="museum-list">
                                        <ul>
                                            <?php foreach($museumList as $museum) { ?>
                                                <li><?= $museum['museum_item']; ?></li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                <?php } ?>
                            </div>

                            <div class="col-12 text-center">
                                <button class="museum-button-toggle gold-button">Read More</button>
                            </div>
                        </div>
                    </div>
                <?php }

                if ( have_posts() ) {
                    get_template_part('templates/shop/product-filter');
                    while ( have_posts() ) {
                        the_post();
                        get_template_part('templates/shop/craft-archive-item');

                    } wp_reset_postdata();
                } else {
                    $noResultsTitle = get_field('no_results_title_craft', 'option');
                    $noResultsDescription = get_field('no_results_description_craft', 'option');
                    ?>
                    <div class="col-12">
                        <div class="no-results">
                            <?php if($noResultsTitle) { ?><h3 class="title"><?= $noResultsTitle; ?></h3><?php } ?>
                            <?php if($noResultsDescription) { ?><div class="description"><?= $noResultsDescription; ?></div><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
            <div class="custom-pagination">
                <?php the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('<', 'textdomain'),
                    'next_text' => __('>', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </section>
</div>

<?php get_footer(); ?>
