const productFilter = () => {
    if ($('.product-filter').length) {
        const slider = document.getElementById('price-range');
        const output = document.getElementById('variable-value');

        //Set Defaults for range slider
        if (slider.value !== '0') {
            output.innerHTML = slider.value;
            const value = (slider.value - slider.min) / (slider.max - slider.min) * 100;
            slider.style.background = `linear-gradient(to right, #AB8D5B 0%, #AB8D5B ${value}%, #9B9B9B ${value}%, #9B9B9B 100%)`;
        }

        //Change range slider on input
        $(slider).on('input', function() {
            output.innerHTML = this.value;
            const value = (this.value - this.min) / (this.max - this.min) * 100;
            this.style.background = `linear-gradient(to right, #AB8D5B 0%, #AB8D5B ${value}%, #9B9B9B ${value}%, #9B9B9B 100%)`;
        });

        $('form.filter-form select.product-order').on('change', function() {
            $(this).closest('form')
                .submit();
        });

        $('.filter-group .filter-button').on('click', function() {
            $(this).next('.filter-options')
                .toggle();
            const icon = $(this).find('svg');
            const iconFaIcon = icon.attr('data-icon');
            iconFaIcon === 'plus' ? icon.attr('data-icon', 'times') : icon.attr('data-icon', 'plus');

            $(this).attr('aria-label', function(i, attr) {
                return attr === 'Open filter options' ? 'Close filter options' : 'Open filter options';
            });
        });

        $('.filter-options .fieldset-title').on('click', function() {
            const dataTitle = $(this).attr('data-title');
            $(this).attr('aria-label', function(i, attr) {
                return attr === `Open ${dataTitle} Filters` ? `Close ${dataTitle} Filters` : `Open ${dataTitle} Filters`;
            });

            const icon = $(this).find('.filter-dropdown-toggle svg');
            const iconFaIcon = icon.attr('data-icon');
            iconFaIcon === 'plus' ? icon.attr('data-icon', 'times') : icon.attr('data-icon', 'plus');
            $(this).next('.checkbox-wrapper')
                .slideToggle();
        });
    }
};

export default productFilter;
