<?php
switch($args['slide_info']['slide_size']) {
    case '25%':
        $widthClass = 'w25';
        $size = 'flexible-split-25';
        break;
    case '33%':
        $widthClass = 'w33';
        $size = 'flexible-split-33';
        break;
    case '50%':
        $widthClass = 'w50';
        $size = 'flexible-split-50';
        break;
    case '66%':
        $widthClass = 'w66';
        $size = 'flexible-split-66';
        break;
    case '100%':
        $widthClass = 'w100';
        $size = 'flexible-split-100';
        break;
}

$artistID = $args['slide_info']['artist_selection'];
$imgID = get_post_thumbnail_id($artistID);
$imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
$imageDetails = wp_get_attachment_image_src($imgID, 'artist-image');
$introduction = get_field('artist_introduction', $artistID);
$description = get_field('artist_description', $artistID);
$film = get_field('featured_artist_film', $artistID);
?>


<div class="swiper-slide draggable-slide <?= $widthClass; ?>">
    <div class="artist-content">
        <div class="about-the-artist__wrapper artist-wrapper">
            <div class="artist-wrapper__title">
                <h2 class="ff-title"><?= get_the_title($artistID) ?></h2>
                <h3>Meet the artist</h3>
            </div>
            <div class="artist-wrapper__grid artist-grid">
                <?php if($imgID) { ?><div class="artist-grid__image"><img src="<?= $imageDetails[0]; ?>" alt="<?= $imageAlt; ?>" loading="lazy"/></div><?php } ?>
                <div class="artist-grid__description">
                    <?php if($introduction) { ?><div class="introduction"><?= $introduction ?></div><?php } ?>
                    <?php if($description) { ?><div class="full"><?= $description ?></div><?php } ?>
                </div>
                <div class="artist-grid__films">
                    <?php if($film) { ?>
                        <div class="frame-holder">
                            <?php \Blue2\Scruffy\Controllers\WhatsOnController::getFeaturedArtistFilm('featured_artist_film', $artistID); ?>
                        </div>
                    <?php } ?>
                    <?php
                    $otherFilms = get_field('films', $artistID);
                    $activeFilms = get_field('activate_films', $artistID);
                    if($activeFilms && $otherFilms) { ?>
                        <a href="<?= get_the_permalink($artistID) . 'films/' ?>" class="gold-button">View all films</a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>

