<?php
global $wp_query;
$queryVars = $wp_query->query_vars;

$firstTabTitle = 'About ' . get_the_title();
$craftTermCheck = has_term('craft-design', 'artist-type');

$activeTabs = [
    'artworks' => get_field('activate_artworks'),
    'events' => get_field('activate_events'),
    'films' => get_field('activate_films'),
    'exhibitions' => get_field('activate_exhibitions'),
    'viewing_rooms' => get_field('activate_viewing_rooms'),
];

$defaultTab = array_key_exists('artworks', $queryVars) || array_key_exists('events', $queryVars) || array_key_exists('films', $queryVars) || array_key_exists('exhibitions', $queryVars) || array_key_exists('viewing_rooms', $queryVars) ? 'order-2' : 'order-1 active';
?>

<section class="p-header whats-on-single-header artist-single-header">
    <div class="p-header__title p-header-title">
        <div class="p-heaer-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) { ?>
                <div class="p-header-title__breadcrumbs ff-title">
                    <span>
                        <span>
                            <a href="<?= home_url(); ?>">Home</a> / <span>
                            <a href="/artists/">Artists</a> /

                            <?php if(array_key_exists('artworks', $queryVars ) || array_key_exists('exhibitions', $queryVars) || array_key_exists('events', $queryVars) || array_key_exists('films', $queryVars) || array_key_exists('viewing_rooms', $queryVars)) { ?>
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> /
                                <?php
                                if(array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true) {
                                    $name = 'Artworks';
                                } elseif(array_key_exists ('exhibitions', $queryVars) && $queryVars['exhibitions'] == true) {
                                    $name = 'Exhibitions';
                                } elseif(array_key_exists ('films', $queryVars) && $queryVars['films'] == true) {
                                    $name = 'Films';
                                } elseif(array_key_exists ('events', $queryVars) && $queryVars['events'] == true) {
                                    $name = 'Events';
                                }
                                ?>
                               <span class="breadcrumb_last" aria-current="page"><?= $name; ?></span></span>
                            <?php } else { ?>
                                 <span class="breadcrumb_last" aria-current="page"><?php the_title(); ?></span></span>
                            <?php } ?>
                        </span>
                    </span>
                </div>
            <?php } ?>

            <div class="holder">
                <?php if($craftTermCheck) { ?>
                    <h2 class="craft-title">Craft <span>&</span> Design</h2>
                <?php } ?>
                <div class="artists ff-title">Artists</div>
                <h1 class="ff-main"><?php the_title(); ?></h1>
            </div>
        </div>
    </div>
    <div class="p-header__filter p-header-filter">
        <div class="p-header-filter_contain contain">
            <div class="filter-wrapper">
                <ul class="ff-title" id="accordion-list">
                    <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                    <li class="default-tab <?= $defaultTab; ?>"><a href="<?php the_permalink(); ?>"><?= $firstTabTitle; ?></a></li>
                    <?php if($activeTabs['artworks'] == true) { ?><li class="artwork-tab <?= array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && ($_GET['type'] !== 'sold') ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'artworks/'; ?>">Artworks</a></li><?php } ?>
                    <?php if($activeTabs['viewing_rooms'] == true) { ?><li class="viewing-rooms-tab <?= array_key_exists ('viewing_rooms', $queryVars) && $queryVars['viewing_rooms'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'viewing-rooms/'; ?>">Viewing Rooms</a></li><?php } ?>
                    <?php if($activeTabs['exhibitions'] == true) { ?><li class="exhibition-tab <?= array_key_exists ('exhibitions', $queryVars) && $queryVars['exhibitions'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'exhibitions/'; ?>">Exhibitions</a></li><?php } ?>
                    <?php if($activeTabs['events'] == true) { ?><li class="events-tab <?= array_key_exists ('events', $queryVars) && $queryVars['events'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'events/'; ?>">Events</a></li><?php } ?>
                    <?php if($activeTabs['films'] == true) { ?><li class="films-tab <?= array_key_exists ('films', $queryVars) && $queryVars['films'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'films/'; ?>">Films</a></li><?php } ?>
                    <?php if($activeTabs['artworks'] == true) { ?><li class="sold-artwork-tab <?= array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && (isset($_GET['type']) && $_GET['type'] == 'sold') ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'artworks/?type=sold'; ?>">Sold Artworks</a></li><?php } ?>
                </ul>
            </div>
        </div>
    </div>
</section>

<?php
if(array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && $activeTabs['artworks']) {
    get_template_part('templates/single-layouts/artworks');
} elseif(array_key_exists ('films', $queryVars) && $queryVars['films'] == true && $activeTabs['films']) {
    get_template_part('templates/single-layouts/films');
} elseif(array_key_exists ('exhibitions', $queryVars) && $queryVars['exhibitions'] == true && $activeTabs['exhibitions']) {
    get_template_part('templates/single-layouts/exhibitions');
} elseif(array_key_exists ('events', $queryVars) && $queryVars['events'] == true && $activeTabs['events']) {
    get_template_part('templates/single-layouts/events');
} elseif(array_key_exists ('viewing_rooms', $queryVars) && $queryVars['viewing_rooms'] == true && $activeTabs['viewing_rooms']) {
    get_template_part('templates/single-layouts/viewing-rooms');
} else {
    if(get_field('flexible_sections')) { ?>
        <div class="flexible-layout">
            <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections'); ?>
        </div>
    <?php }
    get_template_part('templates/single-layouts/associated-artists'); ?>
<?php } ?>


