<?php
$whatsOnArgs = [
    'post_type' => 'whats-on',
    'posts_per_page' => -1,
    'post_status' => 'publish',
    'post_parent' => 0,
    'meta_query' => [
        'relation' => 'AND',
        [
            'key' => 'start_date',
            'value' => date("Y-m-d"),
            'compare' => '<',
            'type' => 'DATE'
        ],
        [
            'key' => 'end_date',
            'value' => date("Y-m-d"),
            'compare' => '<',
            'type' => 'DATE'
        ]
    ],
];

$whatsOnQuery = new WP_Query($whatsOnArgs);

if ( $whatsOnQuery->have_posts() ) {
    while ( $whatsOnQuery->have_posts() ) {
        $whatsOnQuery->the_post();
        $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo();
        if($whatsOnInfo['associated_artists']) {
            $artistNames = [];
            foreach ($whatsOnInfo['associated_artists'] as $artist) {
                array_push($artistNames, $artist->post_title);
            }
        }
        ?>
        <div class="col-sm-6 col-lg-4 col-xl-3 whats-on-item past">
            <a href="<?php the_permalink(); ?>">
                <div class="image-wrapper <?= $whatsOnInfo['archive_image_class']; ?>">
                    <?= $whatsOnInfo['archive_image']; ?>
                </div>
                <div class="content-wrap">
                    <?php if($whatsOnInfo['associated_artists']) { ?><div class="artists ff-title"><?= implode(', ', $artistNames) ?></div><?php } ?>
                    <h2><?php the_title(); ?></h2>
                </div>
            </a>
        </div>
    <?php }
    wp_reset_postdata();
} else {
    get_template_part('templates/whats-on/archive-layouts/no-results');
} ?>

