import matchHeight from 'jquery-match-height/dist/jquery.matchHeight-min';
import Swiper from 'swiper';

const artwork = () => {
    if ($('.artwork-product-item-col').length) {
        $('.artwork-product-item-col .image-wrapper').matchHeight();
        $.fn.matchHeight._afterUpdate = function(event, groups) {
            //stop visible content shift - fades in after matchHeight has finished loading
            const whatsOnContainer = $('.single-artworks-layout__contain');
            const productCatArtworksContainer = $('.artworks-holder');
            if (whatsOnContainer.length) {
                whatsOnContainer.addClass('loaded');
            } else if (productCatArtworksContainer.length) {
                productCatArtworksContainer.addClass('loaded');
            }
        };
    }

    if ($('.whats-on-draggable').length) {
        new Swiper('.artworks-draggable', {
            spaceBetween: 180,
            slidesPerView: 'auto',
            freeMode: true,
            navigation: {
                nextEl: '.custom-button-next',
                prevEl: '.custom-button-prev',
            },
        });

        $('.draggable-expand').on('click', function() {
            $('.whats-on-draggable').toggleClass('popup-active');
            const icon = $(this).find('.toggle-icon')
                .find('svg');
            const iconFaIcon = icon.attr('data-icon');
            iconFaIcon === 'expand-alt' ? icon.attr('data-icon', 'compress-alt') : icon.attr('data-icon', 'expand-alt');
            $(this).attr('aria-label', function(i, attr) {
                return attr === 'Open draggable gallery' ? 'Close draggable gallery' : 'Open draggable gallery';
            });
        });
    }
};

export default artwork;
