<?php
global $wp_query;
$queryVars = $wp_query->query_vars;
$whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo();
$artistNames = [];
if($whatsOnInfo['associated_artists']) {
    foreach ($whatsOnInfo['associated_artists'] as $artist) {
        array_push($artistNames, $artist->post_title);
    }
}

$firstTabTitle = count($artistNames) == 1 ? 'About ' . $artistNames[0] : 'About Exhibition';
$introduction = get_field('exhibition_introduction');
$description = get_field('exhibition_description');
$snippet = get_field('exhibition_snippet');

$activeTabs = [
    'artworks' => get_field('activate_artworks'),
    'viewing_rooms' => get_field('activate_viewing_rooms'),
    'events' => get_field('activate_events'),
    'films' => get_field('activate_films'),
];

$defaultTab = array_key_exists('artworks', $queryVars) || array_key_exists('events', $queryVars) || array_key_exists('films', $queryVars) || array_key_exists('viewing_rooms', $queryVars) ? 'order-2' : 'order-1 active';
?>

<?php if(array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && $activeTabs['artworks'] && get_field('enable_draggable_slider') && (!isset($_GET['type']))) {
    get_template_part('templates/whats-on/draggable-slider/draggable-slider');
} ?>

<section class="p-header whats-on-single-header">
    <div class="p-header__title p-header-title">
        <div class="p-heaer-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) { ?>
                <div class="p-header-title__breadcrumbs ff-title">
                    <span>
                        <span>
                            <a href="<?= home_url(); ?>">Home</a> / <span>
                            <a href="/whats-on/">What's On</a> /

                            <?php if(array_key_exists('artworks', $queryVars ) || array_key_exists('events', $queryVars) || array_key_exists('films', $queryVars) || array_key_exists('viewing_rooms', $queryVars)) { ?>
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> /
                                <?php
                                if(array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true) {
                                    $name = 'Artworks';
                                } elseif(array_key_exists ('films', $queryVars) && $queryVars['films'] == true) {
                                    $name = 'Films';
                                } elseif(array_key_exists ('viewing_rooms', $queryVars) && $queryVars['viewing_rooms'] == true) {
                                    $name = 'Viewing Rooms';
                                } elseif(array_key_exists ('events', $queryVars) && $queryVars['events'] == true) {
                                    $name = 'Events';
                                }
                                ?>
                               <span class="breadcrumb_last" aria-current="page"><?= $name; ?></span></span>
                            <?php } else { ?>
                                 <span class="breadcrumb_last" aria-current="page"><?php the_title(); ?></span></span>
                            <?php } ?>
                        </span>
                    </span>
                </div>
            <?php } ?>

            <div class="holder">
                <?php if($whatsOnInfo['associated_artists']) { ?>
                    <div class="artists ff-title">
                        <?php foreach($whatsOnInfo['associated_artists'] as $artist) { ?>
                            <a href="<?= get_the_permalink($artist->ID); ?>"><?= $artist->post_title; ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>
                <h1 class="ff-main"><?php the_title(); ?></h1>
                <div class="date ff-main"><?= $whatsOnInfo['start_date'] . ' - ' . $whatsOnInfo['end_date']; ?></div>
            </div>
        </div>
    </div>
    <div class="p-header__filter p-header-filter">
        <div class="p-header-filter_contain contain">
            <div class="filter-wrapper">
                <ul class="ff-title" id="accordion-list">
                    <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                    <li class="default-tab <?= $defaultTab; ?>"><a href="<?php the_permalink(); ?>"><?= $firstTabTitle; ?></a></li>
                    <?php if($activeTabs['artworks'] == true) { ?><li class="artwork-tab <?= array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && ($_GET['type'] !== 'sold') ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'artworks/'; ?>">Artworks</a></li><?php } ?>
                    <?php if($activeTabs['viewing_rooms'] == true) { ?><li class="viewing-rooms-tab <?= array_key_exists ('viewing_rooms', $queryVars) && $queryVars['viewing_rooms'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'viewing-rooms/'; ?>">Viewing Rooms</a></li><?php } ?>
                    <?php if($activeTabs['events'] == true) { ?><li class="events-tab <?= array_key_exists ('events', $queryVars) && $queryVars['events'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'events/'; ?>">Events</a></li><?php } ?>
                    <?php if($activeTabs['films'] == true) { ?><li class="films-tab <?= array_key_exists ('films', $queryVars) && $queryVars['films'] == true ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'films/'; ?>">Films</a></li><?php } ?>
                    <?php if($activeTabs['artworks'] == true) { ?><li class="sold-artwork-tab <?= array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && (isset($_GET['type']) && $_GET['type'] == 'sold') ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_the_permalink() . 'artworks/?type=sold'; ?>">Sold Artworks</a></li><?php } ?>
                </ul>
            </div>
        </div>
    </div>
</section>

<?php
if(array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && $activeTabs['artworks']) {
    get_template_part('templates/single-layouts/artworks');
} elseif(array_key_exists ('films', $queryVars) && $queryVars['films'] == true && $activeTabs['films']) {
    get_template_part('templates/single-layouts/films');
} elseif(array_key_exists ('viewing_rooms', $queryVars) && $queryVars['viewing_rooms'] == true && $activeTabs['viewing_rooms']) {
    get_template_part('templates/single-layouts/viewing-rooms');
} elseif(array_key_exists ('events', $queryVars) && $queryVars['events'] == true && $activeTabs['events']) {
    get_template_part('templates/single-layouts/events');
} else { ?>
    <main class="whats-on-info">
        <div class="whats-on-info__exhibition whats-on-info-exhibition">
            <div class="whats-on-info-exhibition__contain contain">
                <div class="row">
                    <?php if($introduction){ ?>
                        <div class="col-lg-6">
                            <div class="whats-on-info-exhibition__introduction"><?= $introduction; ?></div>
                        </div>
                    <?php } ?>
                    <div class="col-lg-6">
                        <?php if($description) { ?><div class="whats-on-info-exhibition__description"><?= $description; ?></div><?php } ?>
                        <?php if($snippet) { ?><div class="whats-on-info-exhibition__snippet"><?= $snippet; ?></div><?php } ?>
                    </div>

                    <?php if(get_post_thumbnail_id()) {
                        $imgID = get_post_thumbnail_id();
                        $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                        $imageDetails = wp_get_attachment_image_src($imgID, 'whats-on-single-full'); ?>
                        <div class="col-12">
                            <div class="whats-on-info-exhibition__image-holder image-holder">
                                <img src="<?= $imageDetails[0]; ?>" alt="<?= $imageAlt; ?>" loading="lazy"/>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </main>
    <?php get_template_part('templates/single-layouts/associated-artists'); ?>
<?php } ?>


