<?php

$queryObject = get_queried_object();

$artworksProductCategory = get_term_by( 'slug', 'artworks', 'product_cat' );
$args = [
    'taxonomy' => 'product_cat',
    'hide_empty' => false,
    'parent'   => $artworksProductCategory->term_id
];
$artworksSubCategories = get_terms( $args );
$activeTaxonomy = (is_tax() && $queryObject->slug) ? $queryObject->slug : "" ;
$filterCount = 0;

?>

<div class="p-header__filter p-header-filter p-collapsable-header-filter">
    <div class="p-header-filter_contain contain">
        <div class="filter-wrapper">
            <ul class="ff-title" id="accordion-list">
                <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                <li class="all-categories <?= is_product_category() && ($queryObject->slug == 'artworks') ? 'active order-1' : 'order-3';  ?>"><a href="/product-category/artworks/">All</a></li>
                <?php if($artworksSubCategories) {
                    foreach ($artworksSubCategories as $subCategory) {
                        $filterCount++;
                        ?>
                        <li class="<?= 'filter-count-'.$filterCount; ?> <?= $subCategory->slug; ?> <?= $activeTaxonomy == $subCategory->slug ? 'active order-1' : 'order-3'; ?>">
                            <a href="<?= get_category_link($subCategory->term_id); ?>"><?= $subCategory->name; ?></a>
                        </li>
                    <?php }
                } ?>
            </ul>
        </div>
    </div>
</div>
