<?php

$id = $args[0];
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

setup_postdata($id);

$productCraftCheck = has_term('craft-design', 'product_cat', $id);
$productPublicationCheck = has_term('publications', 'product_cat', $id);
$productArtworkCheck = has_term('artworks', 'product_cat', $id);

$craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
$publicationProductCategory = get_term_by('slug', 'publications', 'product_cat');
$artworksProductCategory = get_term_by('slug', 'artworks', 'product_cat');

$productCategories = get_the_terms($id, 'product_cat');
if($productCategories) {
    foreach ($productCategories as $category) {
        if ($category->parent == $craftProductCategory->term_id) {
            get_template_part('templates/shop/craft-archive-item');
            break;
        } else if($category->parent == $publicationProductCategory->term_id) {
            get_template_part('templates/shop/publication-archive-item');
            break;
        } else if($category->parent == $artworksProductCategory->term_id) {
            get_template_part('templates/shop/artworks-archive-item');
            break;
        }
    }
}

wp_reset_postdata();
