<?php
$whatsOnArgs = [
    'post_type' => 'whats-on',
    'posts_per_page' => -1,
    'post_status' => 'publish',
    'post_parent' => 0,
    'meta_query' => [
        [
            'key' => 'start_date',
            'value' => date("Y-m-d"),
            'compare' => '>',
            'type' => 'DATE'
        ],
    ],
];

$whatsOnQuery = new WP_Query($whatsOnArgs);

if ( $whatsOnQuery->have_posts() ) {
    while ( $whatsOnQuery->have_posts() ) {
        $whatsOnQuery->the_post();
        $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo();
        if($whatsOnInfo['associated_artists']) {
            $artistNames = [];
            foreach ($whatsOnInfo['associated_artists'] as $artist) {
                array_push($artistNames, $artist->post_title);
            }
        }
        ?>
        <div class="col-lg-6 whats-on-item forthcoming">
            <div class="image-wrapper <?= $whatsOnInfo['archive_image_class']; ?>">
                <a href="<?php the_permalink(); ?>">
                <?= $whatsOnInfo['archive_image'];  ?>
                </a>
            </div>
            <div class="content-wrap">
                <?php if($whatsOnInfo['associated_artists']) { ?>
                    <div class="artists ff-title">
                        <?php foreach($whatsOnInfo['associated_artists'] as $artist) { ?>
                            <a href="<?= get_the_permalink($artist->ID); ?>"><?= $artist->post_title; ?></a>
                        <?php } ?>
                    </div>
                <?php } ?>
                <h2><?php the_title(); ?></h2>
                <div class="date"><?= $whatsOnInfo['start_date'] . ' - ' . $whatsOnInfo['end_date']; ?></div>
                <div class="archive-description"><?= $whatsOnInfo['archive_description']; ?></div>
            </div>
            <div class="cta-wrap">
                <a href="<?php the_permalink(); ?>" class="cta ff-title">Explore More <span class="icon-arrow far fa-long-arrow-right"></span></a>
            </div>
        </div>
    <?php }
    wp_reset_postdata();
} else {
    get_template_part('templates/whats-on/archive-layouts/no-results');
} ?>

