<?php

namespace Blue2\Scruffy\Controllers;

class EventController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('pre_get_posts', [$this, 'eventsArchiveAdjustments']);
    }

    private function registerFilters()
    {

    }

    public function eventsArchiveAdjustments( $query )
    {
        if (!is_admin() && $query->is_main_query() && is_post_type_archive('event')) {
            $postsPerPage = 12;
            date_default_timezone_set('Europe/London');
            $plusHour = date("Y-m-d H:i:s", strtotime('-1 hour'));
            $meta_query = [
                [
                    'key'     => 'end_time',
                    'value'   =>  $plusHour, // Y-m-d H:i:s format
                    'compare' => '>=',
                    'type'    => 'DATETIME'
                ]
            ];
            $query->set('meta_query', $meta_query);
            $query->set('posts_per_page', $postsPerPage);
            $query->set('meta_key', 'date_time');
            $query->set('meta_type', 'DATETIME');
            $query->set('orderby', 'meta_value');
            $query->set('order', 'ASC');
        }
    }
}
