<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$productCraftCheck = false;
$productPublicationCheck = false;
$productArtworkCheck = false;
$queryObject = get_queried_object();

$craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
$publicationProductCategory = get_term_by('slug', 'publications', 'product_cat');
$artworksProductCategory = get_term_by('slug', 'artworks', 'product_cat');

$productCategories = get_the_terms(get_the_id(), 'product_cat');
if($productCategories) {
    foreach ($productCategories as $category) {
        if ($category->parent == $craftProductCategory->term_id) {
            $productCraftCheck = true;
            break;
        } elseif($category->parent == $publicationProductCategory->term_id) {
            $productPublicationCheck = true;
            break;
        } elseif($category->parent == $artworksProductCategory->term_id) {
			$productArtworkCheck = true;
			break;
		}
    }
}

if($productPublicationCheck == true) {
    get_template_part('templates/shop/publication-archive-item');
} elseif($productCraftCheck == true){
    get_template_part('templates/shop/craft-archive-item');
} elseif($productArtworkCheck == true){
	get_template_part('templates/shop/artworks-archive-item');
}
