<?php
global $product;
$associatedArtists = get_field('associated_artists');
$title = get_the_title();
$extraTitleInfo = get_field('extra_title_info');
$additionalInformation = get_field('additional_information');

$length = $product->get_length();
$width = $product->get_width();
$height = $product->get_height();
$diameter = get_post_meta( $product->get_id(), '_diameter', true );

$sizeString = "";

if($length) {
    $sizeString .= "L:" . $length . 'cm ';
}
if($height){
    $sizeString .= "H:" . $height . 'cm ';
}
if($width){
    $sizeString .= "W:" . $width . 'cm ';
}
if($diameter){
    $sizeString .= "D:" . $diameter . 'cm ';
}

$imageData = \Blue2\Scruffy\Site::getPostImage(get_the_id(), 'craft-item');

$col = is_search() ? 'search-full-col' : 'col-sm-6 col-lg-4';

?>
<div class="<?= $col; ?> craft-product-item-col">
    <div class="craft-product-item">
        <div class="craft-product-item__image-wrapper image-wrapper <?= $imageData['class'] ?>">
            <a href="<?php the_permalink(); ?>">
                <?= $imageData['item']; ?>
            </a>
        </div>
        <div class="craft-product-item__info-wrapper content-wrapper">
            <?php if($associatedArtists) { ?>
                <ul class="associated-artists">
                    <?php foreach($associatedArtists as $artist) { ?>
                        <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                    <?php } ?>
                </ul>
            <?php } ?>
            <h2><?= $title; ?><?php if($extraTitleInfo) { echo ', ' . $extraTitleInfo; } ?></h2>
            <?php if($additionalInformation) { ?><div class="additional-info"><?= $additionalInformation; ?></div><?php } ?>
            <?php if($sizeString) { ?><div class="dimensions"><?= $sizeString; ?></div><?php } ?>
        </div>
        <a href="<?php the_permalink(); ?>" class="cta ff-title">View Details <span class="icon-arrow far fa-long-arrow-right"></span></a>
    </div>
</div>
