<?php

$queryObject = get_queried_object();

$publicationCategory = get_term_by( 'slug', 'publications', 'product_cat' );
$args = [
    'taxonomy' => 'product_cat',
    'hide_empty' => false,
    'parent'   => $publicationCategory->term_id
];
$publicationSubCategories = get_terms( $args );
$activeTaxonomy = (is_tax() && $queryObject->slug) ? $queryObject->slug : "" ;
$filterCount = 0;

?>

<div class="p-header__filter p-header-filter p-collapsable-header-filter">
    <div class="p-header-filter_contain contain">
        <div class="filter-wrapper">
            <ul class="ff-title" id="accordion-list">
                <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                <li class="all-categories <?= is_product_category() && ($queryObject->slug == 'publications') ? 'active order-1' : 'order-3';  ?>"><a href="/product-category/publications/">All</a></li>
                <?php if($publicationSubCategories) {
                    foreach ($publicationSubCategories as $subCategory) {
                        $filterCount++;
                        ?>
                        <li class="<?= 'filter-count-'.$filterCount; ?> <?= $subCategory->slug; ?> <?= $activeTaxonomy == $subCategory->slug ? 'active order-1' : 'order-3'; ?>">
                            <a href="<?= get_category_link($subCategory->term_id); ?>"><?= $subCategory->name; ?></a>
                        </li>
                    <?php }
                } ?>
            </ul>
        </div>
    </div>
</div>
