<?php
$id = $args[0];
$postThumbnailID = get_post_thumbnail_id($id);
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

if($postThumbnailID) {
    $imageAlt = get_post_meta($postThumbnailID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($postThumbnailID, 'flexible-standard-media');
    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}
?>
<div class="grid-item">
    <a href="<?= get_the_permalink($id); ?>" class="<?= $imageClass; ?>">
        <?= $image; ?>
        <div class="grid-info">
            <?php if(get_post_type() !== 'page') { ?><div class="date"><?= get_the_date('d F Y', $id); ?></div><?php } ?>
            <h4 class="title"><?= get_the_title($id); ?></h4>
        </div>
    </a>
</div>
