import Swiper from 'swiper';

const search = () => {
    const sliderCount = $('.search-by-post-swiper').length;
    for (let i = 1; i <= sliderCount; i++) {
        const sliderName = `.swiper-${i}`;
        new Swiper(sliderName, {
            watchOverflow: true,
            breakpoints: {
                0: {
                    slidesPerView: 1.1,
                    spaceBetween: 42
                },
                768: {
                    slidesPerView: 2.1,
                    spaceBetween: 42
                },
                1200: {
                    slidesPerView: 3,
                    spaceBetween: 42,
                }
            },

            navigation: {
                nextEl: `.next-${i}`,
                prevEl: `.prev-${i}`,
            },
        });
    }
};

export default search;
