<?php

$artworkClass = 'curated-item';
switch($args['slide_info']['slide_size']) {
    case '25%':
        $widthClass = 'w25';
        $size = 'flexible-split-25';
        break;
    case '33%':
        $widthClass = 'w33';
        $size = 'flexible-split-33';
        break;
    case '50%':
        $widthClass = 'w50';
        $size = 'flexible-split-50';
        break;
    case '66%':
        $widthClass = 'w66';
        $size = 'flexible-split-66';
        break;
    case '100%':
        $widthClass = 'w100';
        $size = 'flexible-split-100';
        break;
}


$id = $args['slide_info']['artwork_selection'];
$product = wc_get_product( $id );

$associatedArtists = get_field('associated_artists', $id);
$title = get_the_title($id);
$extraTitleInfo = get_field('extra_title_info', $id);
$additionalInformation = get_field('additional_information', $id);

$length = $product->get_length($id);
$width = $product->get_width($id);
$height = $product->get_height($id);
$diameter = get_post_meta( $id, '_diameter', true );

$sizeString = "";

if($length) {
    $sizeString .= "L:" . $length . 'cm ';
}
if($height){
    $sizeString .= "H:" . $height . 'cm ';
}
if($width){
    $sizeString .= "W:" . $width . 'cm ';
}
if($diameter){
    $sizeString .= "D:" . $diameter . 'cm ';
}

$imageData = \Blue2\Scruffy\Site::getPostImage($id, $size);

$itemStatus = $product->is_in_stock($id) ? 'in-stock' : 'out-of-stock';
$itemStatusLabel = $product->is_in_stock($id) ? 'Artwork Available' : 'Artwork Unavailable';

?>

<div class="swiper-slide draggable-slide <?= $widthClass; ?>">
    <div class="artwork-content">

        <div class="draggable-item-col <?= $artworkClass; ?>">
            <div class="artwork-product-item">
                <div class="artwork-product-item__image-wrapper image-wrapper <?= $imageData['class'] ?>">
                    <a href="<?php the_permalink($id); ?>">
                        <?= $imageData['item']; ?>
                    </a>
                </div>
                <div class="artwork-product-item__info-wrapper content-wrapper">
                    <?php if($associatedArtists) { ?>
                        <ul class="associated-artists">
                            <?php foreach($associatedArtists as $artist) { ?>
                                <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                    <h2><?= $title; ?><?php if($extraTitleInfo) { echo ', ' . $extraTitleInfo; } ?> <span class="status <?= $itemStatus; ?>" aria-label="<?= $itemStatusLabel; ?>"></span></h2>
                    <?php if($additionalInformation) { ?><div class="additional-info"><?= $additionalInformation; ?></div><?php } ?>
                    <?php if($sizeString) { ?><div class="dimensions"><?= $sizeString; ?></div><?php } ?>
                </div>
                <a href="<?php the_permalink($id); ?>" class="cta ff-title">View Details <span class="icon-arrow far fa-long-arrow-right"></span></a>
            </div>
        </div>

    </div>
</div>
