<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$postThumbnailID = get_post_thumbnail_id();

if($postThumbnailID) {
    $imageAlt = get_post_meta($postThumbnailID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($postThumbnailID, 'artist-image-large');
    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}
?>

<div class="col-sm-6 col-lg-4 col-xl-3 film-item">
    <a href="<?php the_permalink(); ?>">
        <div class="image-wrapper <?= $imageClass; ?>">
            <?= $image; ?>
        </div>
        <div class="content-wrap">
            <h2><?php the_title(); ?></h2>
        </div>
    </a>
</div>
