<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php
    /**
     * Fonts loaded from Typekit but deferred with high priority
     *
     * @see https://csswizardry.com/2020/05/the-fastest-google-fonts/
     */
    $font_url = 'https://use.typekit.net/aes8yuf.css';
    ?>
    <link rel="preconnect" href="https://use.typekit.net" crossorigin>
    <link rel="preconnect" href="https://p.typekit.net" crossorigin>
    <link rel="preload" as="style" href="<?= $font_url; ?>">
    <link rel="stylesheet" href="<?= $font_url; ?>" media="print" onload="this.media='all'" />
    <noscript><link rel="stylesheet" href="<?= $font_url ?>" /></noscript>
    <?php wp_head(); ?>
</head>

<?php
$productCraftCheck = false;
$queryObject = get_queried_object();
$artistCraftCheck = has_term('craft-design', 'artist-type');
$productCraftCheck = has_term('craft-design', 'product_cat');
$craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');

$productCategories = get_the_terms(get_the_id(), 'product_cat');
if($productCategories) {
    foreach ($productCategories as $category) {
        if ($category->parent == $craftProductCategory->term_id) {
            $productCraftCheck = true;
            break;
        }
    }
}

$craft = (is_tax() && $queryObject->slug == 'craft-design') || ($artistCraftCheck && !is_post_type_archive('artist') && !is_search()) || (is_tax() && $queryObject->parent == $craftProductCategory->term_id) || (is_product() && $productCraftCheck) || (is_product() && $productCraftCheck == true) ? 'craft-design-style' : "standard-style";

global $wp_query;
$queryVars = $wp_query->query_vars;
$artworksActive = !isset($_GET['type']) && array_key_exists ('artworks', $queryVars) && $queryVars['artworks'] == true && get_field('enable_draggable_slider') ? 'draggable-artwork-active' : "draggable-artwork-inactive";
?>

<body <?php body_class([$craft, $artworksActive]); ?>>
