<?php
$embed = get_field('film');
$dateOutput = date("d F Y", strtotime(get_the_date()));
?>

<section class="p-header event-single-header event-single-header">
    <div class="p-header__title p-header-title">
        <div class="p-header-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            } ?>

            <div class="holder">
                <h1 class="ff-title"><?php the_title(); ?></h1>
                <div class="date ff-main"><?= $dateOutput; ?></div>
            </div>
        </div>
    </div>
</section>

<main class="single-film-layout">
    <div class="contain single-film-layout__contain">
        <div class="film-output__item">
            <?php if(get_the_content()) { ?>
                <div class="description">
                    <?php the_content(); ?>
                </div>
            <?php } ?>

            <div class="embed-output">
                <?php
                preg_match('/src="(.+?)"/', $embed, $matches);
                $src = $matches[1];
                $params = [
                    'controls'  => 1,
                    'hd'        => 1,
                    'autohide'  => 1,
                    'rel' => 0
                ];
                $new_src = add_query_arg($params, $src);
                $embed = str_replace($src, $new_src, $embed);
                $attributes = 'frameborder="0" loading="lazy"';
                $embed = str_replace('></iframe>', ' ' . $attributes . '></iframe>', $embed);

                echo $embed; ?>
            </div>
        </div>
    </div>
</main>
