<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( $related_products ) : ?>
    <section class="related products">
        <?php
        $heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );
        if ( $heading ) :?>
            <h2 class="related-products-title"><?php echo esc_html( $heading ); ?></h2>
        <?php endif; ?>

        <?php
        $artworkProductCategoryCheck = false;
        $artworkProductCategory = get_term_by('slug', 'artworks', 'product_cat');
        $productCategories = get_the_terms(get_the_id(), 'product_cat');
        if($productCategories) {
            foreach ($productCategories as $category) {
                if ($category->parent == $artworkProductCategory->term_id) {
                    $artworkProductCategoryCheck = true;
                    break;
                }
            }
        }
        $holderClass = $artworkProductCategoryCheck ? 'artworks-holder' : 'item-holder';
        ?>

        <div class="<?= $holderClass; ?>">
            <div class="row d-flex justify-content-center">
                <?php
                $manualRelatedOverride = get_field('related_products_manual_selection');
                if($manualRelatedOverride) {
                    foreach ($manualRelatedOverride as $id) {
                        $post_object = get_post($id);
                        setup_postdata($GLOBALS['post'] =& $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
                        wc_get_template_part('content', 'product');
                    }
                } else {
                    foreach ($related_products as $related_product) {
                        $post_object = get_post($related_product->get_id());
                        setup_postdata($GLOBALS['post'] =& $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
                        wc_get_template_part('content', 'product');
                    }
                }; ?>
            </div>
        </div>
    </section>
<?php
endif;

wp_reset_postdata();
