<?php
$slides = get_field('draggable_slides');
?>
<section class="whats-on-draggable">
    <div class="contain">
        <div class="swiper-container artworks-draggable">
            <div class="swiper-wrapper">
                <?php
                foreach($slides as $slide) {
                    if($slide['slide_type'] == 'text') {
                        get_template_part('templates/whats-on/draggable-slider/slides/text-slide', null, ['slide_info' => $slide]);
                    } elseif($slide['slide_type'] == 'artwork') {
                        get_template_part('templates/whats-on/draggable-slider/slides/artwork-slide', null, ['slide_info' => $slide]);
                    } elseif($slide['slide_type'] == 'artist') {
                        get_template_part('templates/whats-on/draggable-slider/slides/artist-slide', null, ['slide_info' => $slide]);
                    }
                }
                ?>
            </div>
        </div>
        <div class="draggable-navigation">
            <div class="custom-button-prev"><span class="draggable-arrow far fa-long-arrow-left"></span></div>
            <div class="custom-button-next"><span class="draggable-arrow far fa-long-arrow-right"></span></div>
        </div>
    </div>
</section>
