<?php
global $wp_query;
$queryVars = $wp_query->query_vars;
$parentID = wp_get_post_parent_id(get_the_id());
$searchID = $parentID == 0 ? get_the_id() : $parentID;

$args = [
    'post_type' => 'page',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'post_parent' => $searchID,
    'orderby' => 'menu_order',
    'order' => 'ASC',
];
$childPages = get_posts($args);

$currentTitle = $parentID == 0 ? get_the_title() : get_the_title($parentID);
$currentPermalink = $parentID == 0 ? get_the_permalink() : get_the_permalink($parentID);
?>

<section class="p-header standard-header-output">
    <div class="p-header__title p-header-title">
        <div class="p-heaer-title__contain contain">
            <?php if ( function_exists('yoast_breadcrumb') ) {
                yoast_breadcrumb( '<div class="p-header-title__breadcrumbs ff-title">', '</div>' );
            } ?>
            <h1 class="ff-title"><?php the_title(); ?></h1>
        </div>
    </div>
    <?php if($childPages) {
        $counter = 0; ?>
        <div class="p-header__filter p-header-filter">
            <div class="p-header-filter_contain contain">
                <div class="filter-wrapper">
                    <ul class="ff-title" id="accordion-list">
                        <div class="toggle-holder"><span class="accordion-toggle far fa-chevron-down"></span></div>
                        <li class="parent-page <?= $parentID == 0 ? 'active order-1' : 'order-2';  ?>"><a href="<?= $currentPermalink; ?>"><?= $currentTitle; ?></a></li>
                        <?php foreach($childPages as $page) { $counter++; ?>
                            <li class="<?= 'sub-page-' . $counter; ?> <?= $queryVars['pagename'] == $page->post_name ? 'active order-1' : 'order-2'; ?>"><a href="<?= get_permalink($page->ID) ?>"><?= $page->post_title; ?></a></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php } ?>
</section>
