<?php
$title = get_sub_field('section_title');
$blocks = get_sub_field('blocks');
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();

if($blocks) { ?>
    <section class="custom-flexible-section fifty-fifty-info-blocks-section">
        <div class="fifty-fifty-info-blocks-section__contain contain">
            <?php if($title) { ?><h2 class="title text-center"><?= $title; ?></h2><?php } ?>
            <div class="row">
                <?php foreach($blocks as $block) {


                    if($block['image']) {
                        $imageDetails = wp_get_attachment_image_src($block['image']['id'], 'block-slide');
                        $imageAlt = get_post_meta($block['image']['id'], '_wp_attachment_image_alt', TRUE);
                        $slideImage = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                        $imageClass = 'featured-image';
                    } else {
                        $image = $defaultImage;
                        $imageClass = 'default-image';
                    }

                    ?>
                    <div class="col-lg-6 block-col">
                        <div class="block-inner">
                            <div class="row">
                                <div class="col-sm-4 image-col">
                                    <div class="h-100 d-flex align-items-center justify-content-center image-wrapper <?= $imageClass; ?>">
                                        <?= $image; ?>
                                    </div>
                                </div>
                                <div class="col-sm-8 content-col">
                                    <?php if($block['title']) { ?><h3><?= $block['title']; ?></h3><?php } ?>
                                    <?php if($block['description']) { ?><div class="description"><?= $block['description']; ?></div><?php } ?>
                                    <?php if($block['cta']) { ?><a href="<?= $block['cta']['url']; ?>" class="cta gold-button"><?= $block['cta']['title']; ?></a><?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>
