<?php

namespace Blue2\Scruffy\Controllers;

class ArtistController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('init', [$this, 'addArtistSingleEndpoints']);
    }

    private function registerFilters()
    {
        add_filter( 'request', [$this, 'artistSingleFilterRequest']);
    }

    function artistSingleFilterRequest( $vars )
    {
        if( isset( $vars['exhibitions'] ) ) $vars['exhibitions'] = true;
        return $vars;
    }

    public function addArtistSingleEndpoints()
    {
        add_rewrite_endpoint('exhibitions', EP_PERMALINK | EP_PAGES);
    }

    public function registerTaxonomies()
    {
        $artistType = new \Blue2\Common\Taxonomy("artist-type", "Artist Type", "Artist Types", "artist", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

}
