<?php
get_template_part('templates/sections/standard-page-header');
$galleryStaffMembers = get_field('gallery_staff_members');
?>

<div class="gallery-staff-output">
    <div class="contain">
        <?php if($galleryStaffMembers) {
            $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
            ?>

            <div class="row row-eq-height">
                <?php foreach($galleryStaffMembers as $member) {
                    $imgID = $member['image'];
                    if($imgID) {
                        $imageAlt = get_post_meta($imgID, '_wp_attachment_image_alt', TRUE);
                        $imageDetails = wp_get_attachment_image_src($imgID, 'artist-image-large');
                        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                        $imageClass = 'featured-image';
                    } else {
                        $image = $defaultImage;
                        $imageClass = 'default-image';
                    }
                    ?>
                    <div class="col-sm-6 col-lg-4 col-xl-3 gallery-staff-col">
                        <div class="image-wrapper <?= $imageClass; ?>">
                            <?= $image; ?>
                        </div>
                        <div class="content-wrap">
                            <div class="staff-name ff-title"><?= $member['name']; ?></div>
                            <?php if($member['position']) { ?><h2><?= $member['position'] ?></h2><?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</div>
