<?php
$socials = get_field('social_media_channels', 'option');
?>

<header class="l-header">
    <div class="l-header__wrapper">
        <div class="l-header__contain contain">
            <a class="l-header__brand" href="<?= esc_url(home_url('/')); ?>">
                <?php
                $path = get_template_directory() . '/dist/images/TSG-main-logo.svg';
                $file = file_get_contents($path);
                $file = str_replace(
                    '<?xml version="1.0" encoding="UTF-8"?>',
                    '',
                    $file
                );
                echo str_replace(
                    '<svg',
                    '<svg class="l-header__logo" role="img" aria-label="The Scottish Gallery"',
                    $file
                );
                ?>
            </a>
            <nav class="l-header__nav l-nav">
                <div class="l-nav__holder ff-main">
                    <?php
                    if (has_nav_menu( 'main_menu' )) {
                        wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'l-nav__menu']);
                    }
                    ?>
                    <div class="l-nav__icons l-icons">
                        <button class="l-icons__search" aria-label="Open Search Bar"><span class="far fa-search"></span></button>
                        <a href="<?= wc_get_cart_url(); ?>" role="button" class="l-icons__basket" aria-label="Open Shopping Bag">
                            <span class="l-icons__basket far fa-shopping-bag"></span>
                            <?php
                            global $woocommerce;
                            $cartCount = $woocommerce->cart->cart_contents_count;
                            if ($cartCount > 0) {
                                echo '<span class="cart-total-badge">'.$cartCount.'</span>';
                            }
                            ?>
                        </a>
                        <button class="l-icons__hamburger" aria-label="Open Secondary Navigation"><span class="far fa-bars hamburger-icon"></span></button>
                    </div>
                </div>
            </nav>
            <nav class="l-hamburger__nav hamburger-nav ff-title" aria-expanded="false">
                <div class="hamburger-nav__close"><span class="l-icons__hamburger-close far fa-times" aria-label="Close Secondary Navigation" role="button"></span></div>
                <div class="hamburger-holder">
                    <?php
                    if (has_nav_menu( 'hamburger_menu' )) {
                        wp_nav_menu(['theme_location' => 'hamburger_menu', 'menu_class' => 'hamburger-nav__menu']);
                    }
                    ?>
                </div>
                <?php if($socials) { ?>
                    <ul class="hamburger-nav__socials">
                        <?php foreach($socials as $social) { ?>
                            <li><a href="<?= $social['full_url']; ?>" target="_blank"><span class="fab <?= $social['platform'] ?>"></span></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </nav>
        </div>
    </div>

    <?php get_template_part('templates/sections/search/search-popup'); ?>

</header>

<div class="search-bg"></div>
