<?php

namespace Blue2\Scruffy\Controllers;

class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'woocommerceHookAdjustments']);
        add_action('pre_get_posts', [$this, 'productArchiveAdjustmentsAndFilter']);
        add_action( 'woocommerce_product_options_dimensions', [$this, 'add_product_options_other_dimensions']);
        add_action( 'woocommerce_process_product_meta', [$this, 'save_product_options_other_dimensions']);
    }

    private function registerFilters()
    {
        add_filter('template_include', [$this, 'taxonomyTemplateFallbackAdjustments'], 11);
        add_filter('woocommerce_product_related_products_heading', [$this, 'relatedProductsTitle']);
        add_filter( 'woocommerce_output_related_products_args', [$this, 'relatedProductsCount'], 20 );
    }

    public function woocommerceHookAdjustments() {
        remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
        remove_action('woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
    }

    public function productArchiveAdjustmentsAndFilter( $query ) {
        if ( !is_admin() && $query->is_main_query() && is_tax('product_cat')) {
            $queryObject = $query->queried_object;
            $craftProductCategory = get_term_by('slug', 'craft-design', 'product_cat');
            $publicationProductCategory = get_term_by('slug', 'publications', 'product_cat');
            $artworksProductCategory = get_term_by('slug', 'artworks', 'product_cat');

            if($queryObject->parent == $craftProductCategory->term_id || $queryObject->term_id == $craftProductCategory->term_id) {
                $postsPerPage = get_field('craft_products_per_page_archive', 'option') ?: 12;
                $query->set('posts_per_page', $postsPerPage);
            } elseif($queryObject->parent == $publicationProductCategory->term_id || $queryObject->term_id == $publicationProductCategory->term_id) {
                $postsPerPage = get_field('publication_products_per_page_archive', 'option') ?: 12;
                $query->set('posts_per_page', $postsPerPage);
            } elseif($queryObject->parent == $artworksProductCategory->term_id || $queryObject->term_id == $artworksProductCategory->term_id) {
                $postsPerPage = get_field('artwork_products_per_page_archive', 'option') ?: 12;
                $query->set('posts_per_page', $postsPerPage);
            }

            if(isset($_POST)) {

                $metaQuery = ['relation' => 'AND'];
                $taxQuery = ['relation' => 'AND'];

                if(array_key_exists('filter-artist', $_POST)) {

                    $artistQuery = ['relation' => 'OR'];

                    foreach($_POST['filter-artist'] as $id) {
                        $artistQuery[] = [
                            'key' => 'associated_artists',
                            'value' => '"' . $id . '"',
                            'compare' => 'LIKE'
                        ];
                    }

                    $metaQuery = [
                        $metaQuery[] = $artistQuery
                    ];
                }

                if(array_key_exists('price-range', $_POST) && $_POST['price-range'] !== "0") {
                    $metaQuery[] = [
                        'key' => '_price',
                        'value' => [0, $_POST['price-range']],
                        'compare' => 'between',
                        'type'    => 'numeric',
                    ];
                }

                if(array_key_exists('filter-medium', $_POST)) {
                    $taxQuery[] = [
                        'taxonomy' => 'medium',
                        'field' => 'slug',
                        'terms' => $_POST['filter-medium'],
                    ];
                }

                if(array_key_exists('filter-subject', $_POST)) {
                    $taxQuery[] = [
                        'taxonomy' => 'subject',
                        'field' => 'slug',
                        'terms' => $_POST['filter-subject'],
                    ];
                }

                if (array_key_exists('product-order', $_POST)) {
                    if ($_POST['product-order'] == 'price') {
                        $query->set('orderby', 'meta_value_num');
                        $query->set('meta_key', '_price');
                        $query->set('order', 'ASC');
                    } else if ($_POST['product-order'] == 'price-desc') {
                        $query->set('orderby', 'meta_value_num');
                        $query->set('meta_key', '_price');
                        $query->set('order', 'DESC');
                    } else if($_POST['product-order'] == 'popularity'){
                        $query->set('orderby', 'post_views');
                        $query->set('order', 'DESC');
                    } else if($_POST['product-order'] == 'date'){
                        $query->set('orderby', 'date');
                        $query->set('order', 'DESC');
                    }
                }

                $query->set('tax_query', $taxQuery);
                $query->set('meta_query', $metaQuery);
            }
        }
    }

    function taxonomyTemplateFallbackAdjustments( $template ) {
        if ( is_tax('product_cat') ) {
            $craftDesign = get_term_by('slug', 'craft-design', 'product_cat');
            $publications = get_term_by('slug', 'publications', 'product_cat');
            $artworks = get_term_by('slug', 'artworks', 'product_cat');

            //todo - add artworks taxonomy template

            if (term_is_ancestor_of($craftDesign, get_queried_object(), 'product_cat')) {
                return get_template_directory() . '/taxonomy-product_cat-craft-design.php';
            } elseif(term_is_ancestor_of($publications, get_queried_object(), 'product_cat')){
                return get_template_directory() . '/taxonomy-product_cat-publications.php';
            } elseif(term_is_ancestor_of($artworks, get_queried_object(), 'product_cat')){
                return get_template_directory() . '/taxonomy-product_cat-artworks.php';
            }
        }
        return $template;
    }

    function add_product_options_other_dimensions(){
        global $product_object;
        $product_id = method_exists( $product_object, 'get_id' ) ? $product_object->get_id() : $product_object->id;
        echo '</div><div class="options_group">'; // New option group
        woocommerce_wp_text_input([
            'id'          => '_diameter',
            'label'       => __( 'Diameter (cm)', 'woocommerce' ),
            'desc_tip'    => 'true',
            'description' => __( 'Diameter description help.', 'woocommerce' )
        ]);
    }

    function save_product_options_other_dimensions( $post_id ){
        if(isset($_POST['_diameter'])) {
            update_post_meta($post_id, '_diameter', esc_attr($_POST['_diameter']));
        }
    }

    function relatedProductsTitle(){
        $title = get_field('related_products_title') ?: 'Related Items';
        return $title;
    }


    function relatedProductsCount( $args ) {
        $args['posts_per_page'] = 3;
        return $args;
    }

}
