<?php
get_header();

$searchArgs = [
    'keyword' => $_GET['s'],
    'curated' => isset($_GET['search-curated']) ? $_GET['search-curated'] : "",
    'price' => $_GET['search-price'] ?: "",
    'artist' => $_GET['search-artist'] ?: "",
    'medium' => $_GET['search-medium'] ?: "",
    'subject' => $_GET['search-subject'] ?: "",
];

$title = isset($_GET['s']) && $_GET["s"] ? "Search Results for: *" . $_GET['s'] . "*" : "Search Results";

$resultsByPostType = [];
$resultsCounter = 0;

if ( have_posts() ) {
    while ( have_posts() ) {
        the_post();
        $resultsByPostType[get_post_type()][] = get_the_id();
    } wp_reset_postdata();
}
?>
<div class="custom-search-results">
    <div class="custom-search-results__contain contain">
        <h1 class="ff-title"><?= $title; ?></h1>
        <?php if ($resultsByPostType) { ?>
            <div class="search-output">
                <?php foreach($resultsByPostType as $key => $ids) {
                    $resultsCounter++;
                    $postTypeInfo = get_post_type_object($key);
                    $posts = get_posts(['post_type'=> $key, 'include' => $ids, 'numberposts' => -1]);
                    $postsCount = count($posts);

                    switch($key) {
                        case 'post':
                            $title = 'News';
                            break;
                        case 'whats-on':
                            $title = 'Exhibitions';
                            break;
                        default:
                            $title = $postTypeInfo->label;
                    }

                    ?>
                    <section class="search-section <?= 'section-' . $key; ?>">
                        <div class="top-holder">
                            <div class="title">
                                <h2><?= $title; ?></h2>
                                <div class="count"><?= $postsCount == 1 ? $postsCount . ' Result' : $postsCount . ' Results'; ?></div>
                            </div>
                            <div class="custom-nav-directions">
                                <div class="custom-button-prev <?= 'prev-' . $resultsCounter; ?> custom-nav-direction"><span class="far fa-long-arrow-left"></span></div>
                                <div class="custom-button-next <?= 'next-' . $resultsCounter; ?> custom-nav-direction"><span class="far fa-long-arrow-right"></span></div>
                            </div>
                        </div>
                        <div class="swiper-container search-by-post-swiper <?= 'swiper-' . $resultsCounter; ?>">
                            <div class="swiper-wrapper">
                                <?php foreach($posts as $post) { ?>
                                    <div class="swiper-slide">
                                        <?php switch($key) {
                                            case 'whats-on':
                                                get_template_part('templates/sections/search/blocks/whats-on-and-events', 'whats-on-and-events-search-block', [$post->ID]);
                                                break;
                                            case 'post':
                                                get_template_part('templates/sections/search/blocks/page-post', 'page-post-search-block', [$post->ID]);
                                                break;
                                            case 'page':
                                                get_template_part('templates/sections/search/blocks/page-post', 'page-post-search-block', [$post->ID]);
                                                break;
                                            case 'artist':
                                                get_template_part('templates/sections/search/blocks/artist', 'artist-search-block', [$post->ID]);
                                                break;
                                            case 'product':
                                                get_template_part('templates/sections/search/blocks/product', 'product-search-block', [$post->ID]);
                                                break;
                                            case 'event':
                                                get_template_part('templates/sections/search/blocks/whats-on-and-events', 'whats-on-and-event-search-block', [$post->ID]);
                                                break;
                                        } ?>
                                    </div>
                                <?php } wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </section>
                <?php } ?>
            </div>
        <?php } else { ?>
            <div class="search-output no-results">
                <div class="row row-eq-height">
                    <div class="col-12">
                        <div class="no-results-found">No results have been found which match your search criteria.</div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<?php get_footer(); ?>
