<?php
global $product;
$associatedArtists = get_field('associated_artists');
$title = get_the_title();
$imageData = \Blue2\Scruffy\Site::getPostImage(get_the_id(), 'flexible-image-block-4');
?>
<div class="col-sm-6 col-md-4 col-lg-3 publication-product-item-col">
    <div class="publication-product-item">
        <div class="publication-product-item__image-wrapper image-wrapper <?= $imageData['class'] ?>">
            <a href="<?php the_permalink(); ?>">
                <?php if(!$product->is_in_stock()) { ?>
                    <span class="out-of-stock ff-title">Out of Stock</span>
                <?php } ?>
                <?= $imageData['item']; ?>
            </a>
        </div>
        <div class="publication-product-item__info-wrapper content-wrapper">
            <?php if($associatedArtists) { ?>
                <ul class="associated-artists">
                    <?php foreach($associatedArtists as $artist) { ?>
                        <li class="ff-title"><a href="<?= get_the_permalink($artist); ?>"><?= get_the_title($artist); ?></a></li>
                    <?php } ?>
                </ul>
            <?php } ?>
            <h2><?= $title; ?></h2>
            <?php if($product->get_price()) { ?><div class="price"><?= get_woocommerce_currency_symbol() . $product->get_price(); ?></div><?php } ?>
        </div>
    </div>
</div>
