<?php
$id = $args[0];


if(get_post_type($id) == 'whats-on') {
    $whatsOnInfo = \Blue2\Scruffy\Controllers\WhatsOnController::getWhatsOnArchiveInfo($id, 'block-slide');
    $artistNames = [];
    if ($whatsOnInfo['associated_artists']) {
        foreach ($whatsOnInfo['associated_artists'] as $artist) {
            array_push($artistNames, $artist->post_title);
        }
    }
    $mainTitle = implode(', ', $artistNames) ?: "";
    $subtitle = $whatsOnInfo['title'];
    $imageClass = $whatsOnInfo['archive_image_class'];
    $image = $whatsOnInfo['archive_image'];
    $startDate = $whatsOnInfo['start_date'];
    $endDate = $whatsOnInfo['end_date'];
    $description = $whatsOnInfo['archive_description'];
    $link = get_the_permalink($id);
} else {
    $mainTitle = get_the_title($id);
    $description = get_the_excerpt($id);
    $subtitle = get_field('subtitle', $id) ?: 'Event';
    $startDate = date("l jS F, h:ia", strtotime(get_field('date_time', $id)));
    $endDate = "";

    $imageData = \Blue2\Scruffy\Site::getPostImage($id, 'block-slide');
    $imageClass = $imageData['class'];
    $image = $imageData['item'];
    $link = get_the_permalink($id);
}

?>

<div class="whats-on-search-slide">
    <div class="image-wrapper <?= $imageClass; ?>">
        <a href="<?= $link; ?>">
            <?= $image; ?>
        </a>
    </div>
    <div class="content-wrapper">
        <div class="title-holder">
            <h2 class="ff-title"><?= $mainTitle; ?></h2>
            <?php if($subtitle) { ?><h3 class="ff-title"><?= $subtitle; ?></h3><?php } ?>
            <?php if($startDate || $endDate) { ?><div class="date"><span class="start-date"><?= $startDate; ?></span><?php if($endDate) { ?><span class="end-date"> - <?= $endDate ?></span><?php } ?></div><?php } ?>
        </div>
        <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
        <a href="<?= $link; ?>" class="cta ff-title">Explore More <span class="icon-arrow far fa-long-arrow-right"></span></a>
    </div>
</div>
