<?php
$selectedEvents = get_sub_field('events');
$eventArgs = [
    'post_type' => 'event',
    'numberposts' => 4,
    'meta_query' => [
        [
            'key' => 'date_time',
            'value' => date("Y-m-d"),
            'compare' => '>',
            'type' => 'DATETIME',
        ]
    ],
    'orderby' => 'meta_value',
    'order' => 'ASC'
];
$events = $selectedEvents ?: get_posts($eventArgs);

$eventCount = count($events);

if($events) {

    $defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
    $featuredEventImageID = get_post_thumbnail_id($events[0]->ID);
    $featuredEventDescription = get_post_field('post_content', $events[0]->ID);

    if($featuredEventImageID) {
        $imageAlt = get_post_meta($featuredEventImageID, '_wp_attachment_image_alt', TRUE);
        $imageDetails = wp_get_attachment_image_src($featuredEventImageID, 'featured-event-image');
        $featuredEventImage = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
        $featuredEventImageClass = 'featured-image';
    } else {
        $featuredEventImage = $defaultImage;
        $featuredEventImageClass = 'default-image';
    }

    ?>
    <section class="custom-flexible-section events-section">
        <div class="events-section__contain contain">
            <h2 class="title text-center">Events</h2>
            <div class="row">
                <div class="<?= $eventCount == 1 ? 'offset-lg-2 col-lg-8' : 'col-md-12 col-lg-7 col-xl-8' ?>">
                    <div class="featured-event event-item">


                            <div class="image-wrapper <?= $featuredEventImageClass; ?>">
                                <a href="<?= get_the_permalink($events[0]->ID); ?>" class="image-link">
                                    <?= $featuredEventImage; ?>
                                </a>
                            </div>


                        <div class="row row-eq-height content-wrapper">
                            <div class="col-lg-6">
                                <div class="inner">
                                    <div class="date"><?= date("l jS F, h:ia", strtotime(get_field('date_time', $events[0]->ID))); ?></div>
                                    <h3><?= get_the_title($events[0]->ID); ?></h3>
                                    <?php if(get_field('subtitle', $events[0]->ID)) { ?><h4><?php the_field('subtitle', $events[0]->ID); ?></h4><?php } ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="inner featured-inner-holder">
                                    <?php if($featuredEventDescription) { ?><div class="description"><?= $featuredEventDescription; ?></div><?php } ?>
                                    <a href="<?= get_the_permalink($events[0]->ID); ?>" class="cta ff-title">Explore More <span class="icon-arrow far fa-long-arrow-right"></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="<?= $eventCount == 1 ? 'd-none' : 'col-md-12 col-lg-5 col-xl-4' ?>">
                    <?php foreach(array_slice($events, 1) as $event) {

                        $eventThumbnailID = get_post_thumbnail_id($event->ID);

                        if($eventThumbnailID) {
                            $imageAlt = get_post_meta($eventThumbnailID, '_wp_attachment_image_alt', TRUE);
                            $imageDetails = wp_get_attachment_image_src($eventThumbnailID, 'small-event-image');
                            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                            $imageClass = 'featured-image';
                        } else {
                            $image = $defaultImage;
                            $imageClass = 'default-image';
                        }


                        ?>
                        <div class="standard-event event-item">
                            <a href="<?= get_permalink($event->ID); ?>">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="image-wrapper <?= $imageClass; ?>">
                                            <?= $image; ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 content-col">
                                        <div class="date"><?= date("l jS F, h:ia",  strtotime(get_field('date_time', $event->ID))); ?></div>
                                        <h3><?= get_the_title($event->ID); ?></h3>
                                        <?php if(get_field('subtitle', $event->ID)) { ?><h4><?php the_field('subtitle', $event->ID); ?></h4><?php } ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php } wp_reset_postdata(); ?>
                </div>
            </div>
            <div class="view-all-events">
                <a href="/events/" class="gold-button">View all events</a>
            </div>
        </div>
    </section>
<?php } ?>
